/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.modifier;

import foundry.veil.impl.client.render.shader.modifier.ShaderModificationParser;
import foundry.veil.impl.client.render.shader.modifier.ShaderModificationSyntaxException;
import foundry.veil.impl.client.render.shader.modifier.ShaderModifierLexer;
import java.io.IOException;
import java.util.regex.Pattern;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public interface ShaderModification {
    public static final Pattern VERSION_PATTERN = Pattern.compile("^#version\\s+(\\d+)\\s*\\w*\\s*", 8);
    public static final Pattern OUT_PATTERN = Pattern.compile("^out (\\w+) (\\w+)\\s*;\\s*", 8);
    public static final Pattern IN_PATTERN = Pattern.compile("^(?:layout\\(.*\\))?\\s*in (\\w+) (\\w+)\\s*;\\s*", 8);
    public static final Pattern UNIFORM_PATTERN = Pattern.compile("^uniform \\w+ \\w+\\s*;\\s*", 8);
    public static final Pattern RETURN_PATTERN = Pattern.compile("return\\s+.+;");
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("#(\\w+)");
    public static final int APPLY_VERSION = 1;
    public static final int ALLOW_OUT = 2;

    public String inject(String var1, int var2) throws IOException;

    public int getPriority();

    public static ShaderModification parse(String input, boolean vertex) throws ShaderModificationSyntaxException {
        return ShaderModificationParser.parse(ShaderModifierLexer.createTokens(input), vertex);
    }

    public record Function(String name, Pattern pattern, int parameters, boolean head, String code) {
        public static Function create(String name, int parameters, boolean head, String code) {
            if (parameters == -1) {
                return new Function(name, Pattern.compile("\\w+\\s+" + name + "\\s*\\([^)]*\\)[^{]*\\{"), parameters, head, code);
            }
            if (parameters == 0) {
                return new Function(name, Pattern.compile("\\w+\\s+" + name + "\\s*\\(\\s*\\)[^{]*\\{"), parameters, head, code);
            }
            if (parameters == 1) {
                return new Function(name, Pattern.compile("\\w+\\s+" + name + "\\s*\\(\\s*\\w+\\s\\w+)\\)[^{]*\\{"), parameters, head, code);
            }
            return new Function(name, Pattern.compile("\\w+\\s+" + name + "\\s*\\(((\\s*\\w+\\s\\w+,)\\{" + (parameters - 1) + "}\\s*\\w+\\s\\w+)\\)[^{]*\\{"), parameters, head, code);
        }
    }
}

