/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.definition;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.impl.client.render.shader.definition.ShaderBlockImpl;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL15C;
import org.lwjgl.opengl.GL30C;
import org.lwjgl.system.MemoryStack;

@ApiStatus.Internal
public class SizedShaderBlockImpl<T>
extends ShaderBlockImpl<T> {
    private final int size;

    public SizedShaderBlockImpl(int size, BiConsumer<T, ByteBuffer> serializer) {
        super(serializer);
        this.size = size;
    }

    @Override
    public void bind(int index) {
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxUniformBuffersBindings(), (long)index);
        if (this.buffer == 0) {
            this.buffer = GL15C.glGenBuffers();
            GL15C.glBindBuffer((int)35345, (int)this.buffer);
            GL15C.glBufferData((int)35345, (long)this.size, (int)35048);
            GL15C.glBindBuffer((int)35345, (int)0);
            this.dirty = true;
        }
        if (this.dirty) {
            this.dirty = false;
            GL15C.glBindBuffer((int)35345, (int)this.buffer);
            try (MemoryStack stack = MemoryStack.stackPush();){
                if (this.value != null) {
                    ByteBuffer buffer = stack.malloc(this.size);
                    this.serializer.accept(this.value, buffer);
                    GL15C.glBufferSubData((int)35345, (long)0L, (ByteBuffer)buffer);
                } else {
                    GL15C.glBufferSubData((int)35345, (long)0L, (ByteBuffer)stack.calloc(this.size));
                }
            }
            GL15C.glBindBuffer((int)35345, (int)0);
        }
        GL30C.glBindBufferRange((int)35345, (int)index, (int)this.buffer, (long)0L, (long)this.size);
    }

    @Override
    public void unbind(int index) {
        Validate.inclusiveBetween((long)0L, (long)VeilRenderSystem.maxUniformBuffersBindings(), (long)index);
        GL30C.glBindBufferRange((int)35345, (int)index, (int)this.buffer, (long)0L, (long)this.size);
    }
}

