/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.shader.definition;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.shader.definition.ShaderBlock;
import java.nio.ByteBuffer;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL15C;

@ApiStatus.Internal
public abstract class ShaderBlockImpl<T>
implements ShaderBlock<T> {
    protected final BiConsumer<T, ByteBuffer> serializer;
    protected int buffer;
    protected T value;
    protected boolean dirty;

    protected ShaderBlockImpl(BiConsumer<T, ByteBuffer> serializer) {
        this.serializer = serializer;
        this.buffer = 0;
        this.value = null;
        this.dirty = false;
    }

    @Override
    public void set(@Nullable T value) {
        this.value = value;
        this.dirty = true;
    }

    public abstract void bind(int var1);

    public abstract void unbind(int var1);

    @Override
    @Nullable
    public T getValue() {
        return this.value;
    }

    public void free() {
        VeilRenderSystem.unbind(this);
        if (this.buffer != 0) {
            GL15C.glDeleteBuffers((int)this.buffer);
            this.buffer = 0;
        }
    }
}

