/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.pipeline;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.post.PostPipeline;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class PostPipelineContext
implements PostPipeline.Context,
NativeResource {
    private final VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);
    private final Map<CharSequence, Integer> samplers = new HashMap<CharSequence, Integer>();
    private final Map<ResourceLocation, AdvancedFbo> framebuffers = new HashMap<ResourceLocation, AdvancedFbo>();

    public PostPipelineContext() {
        this.setupScreenQuad();
    }

    private void setupScreenQuad() {
        Tesselator tesselator = RenderSystem.renderThreadTesselator();
        BufferBuilder bufferBuilder = tesselator.getBuilder();
        bufferBuilder.begin(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.POSITION);
        bufferBuilder.vertex(-1.0, 1.0, 0.0).endVertex();
        bufferBuilder.vertex(-1.0, -1.0, 0.0).endVertex();
        bufferBuilder.vertex(1.0, 1.0, 0.0).endVertex();
        bufferBuilder.vertex(1.0, -1.0, 0.0).endVertex();
        this.vbo.bind();
        this.vbo.upload(bufferBuilder.end());
        VertexBuffer.unbind();
    }

    public void begin() {
        VeilRenderSystem.renderer().getFramebufferManager().getFramebuffers().forEach(this::setFramebuffer);
        this.setFramebuffer(VeilFramebuffers.MAIN, AdvancedFbo.getMainFramebuffer());
        this.setFramebuffer(VeilFramebuffers.POST, this.getDrawFramebuffer());
    }

    public void end() {
        this.samplers.clear();
        this.framebuffers.clear();
    }

    @Override
    public void drawScreenQuad() {
        this.vbo.bind();
        this.vbo.draw();
        VertexBuffer.unbind();
    }

    @Override
    public void setSampler(CharSequence name, int id) {
        this.samplers.put(name, id);
    }

    @Override
    public void setFramebuffer(ResourceLocation name, AdvancedFbo framebuffer) {
        this.framebuffers.put(name, framebuffer);
    }

    @Override
    public void applySamplers(ShaderProgram shader) {
        this.samplers.forEach(shader::addSampler);
    }

    @Override
    @Nullable
    public AdvancedFbo getFramebuffer(ResourceLocation name) {
        return this.framebuffers.get(name);
    }

    @Override
    public AdvancedFbo getDrawFramebuffer() {
        return this.framebuffers.getOrDefault(VeilFramebuffers.POST, AdvancedFbo.getMainFramebuffer());
    }

    public void free() {
        this.vbo.close();
    }
}

