/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render.deferred.light;

import com.mojang.blaze3d.vertex.VertexBuffer;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.LightTypeRenderer;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.shader.VeilShaders;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.Direction;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class VanillaLightRenderer
implements NativeResource {
    private final VertexBuffer vbo = new VertexBuffer(VertexBuffer.Usage.STATIC);

    public VanillaLightRenderer() {
        this.vbo.bind();
        this.vbo.upload(LightTypeRenderer.createQuad());
        VertexBuffer.unbind();
    }

    public void render(LightRenderer lightRenderer, ClientLevel level) {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        boolean useBaked = renderer.getShaderDefinitions().getDefinition("USE_BAKED_TRANSPARENT_LIGHTMAPS") != null && lightRenderer.getFramebuffer() == renderer.getFramebufferManager().getFramebuffer(VeilFramebuffers.TRANSPARENT);
        VeilRenderSystem.setShader(useBaked ? VeilShaders.LIGHT_VANILLA : VeilShaders.LIGHT_VANILLA_LIGHTMAP);
        lightRenderer.applyShader();
        ShaderProgram shader = VeilRenderSystem.getShader();
        if (shader == null) {
            return;
        }
        for (Direction direction : Direction.values()) {
            shader.setFloat("LightShading" + direction.ordinal(), level.getShade(direction, true));
        }
        this.vbo.bind();
        this.vbo.draw();
        VertexBuffer.unbind();
    }

    public void free() {
        this.vbo.close();
    }
}

