/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.util.TextureDownloader;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL20C;

@ApiStatus.Internal
public class TextureEditor
extends SingleWindowEditor {
    private final IntSet texturesSet = new IntArraySet();
    private final Map<Integer, OpenTexture> openTextures = new HashMap<Integer, OpenTexture>();
    private final ImBoolean flip = new ImBoolean();
    private int[] textures = new int[0];
    private int selectedTexture = 0;
    private boolean downloadTextures;
    private CompletableFuture<?> downloadFuture = null;

    private void scanTextures() {
        this.texturesSet.clear();
        for (int i = 0; i < 10000; ++i) {
            if (!GL20C.glIsTexture((int)i)) continue;
            this.texturesSet.add(i);
        }
        if (this.textures.length != this.texturesSet.size()) {
            if (!this.texturesSet.contains(this.selectedTexture)) {
                this.selectedTexture = 0;
            }
            this.textures = this.texturesSet.toIntArray();
            this.openTextures.keySet().removeIf(a -> !this.texturesSet.contains(a.intValue()));
        }
    }

    @Override
    public String getDisplayName() {
        return "Textures";
    }

    @Override
    protected void renderComponents() {
        this.scanTextures();
        int selectedId = this.selectedTexture < 0 || this.selectedTexture >= this.textures.length ? 0 : this.textures[this.selectedTexture];
        int[] value = new int[]{this.selectedTexture};
        ImGui.beginDisabled((this.textures.length == 0 ? 1 : 0) != 0);
        ImGui.setNextItemWidth((float)(ImGui.getContentRegionAvailX() / 2.0f));
        if (ImGui.sliderInt((String)"##textures", (int[])value, (int)0, (int)(this.textures.length - 1), (String)(selectedId == 0 ? "No Texture" : Integer.toString(selectedId)))) {
            this.selectedTexture = value[0];
        }
        ImGui.endDisabled();
        ImGui.sameLine();
        ImGui.pushButtonRepeat((boolean)true);
        ImGui.beginDisabled((this.selectedTexture <= 0 ? 1 : 0) != 0);
        if (ImGui.arrowButton((String)"##left", (int)0)) {
            --this.selectedTexture;
        }
        ImGui.endDisabled();
        ImGui.beginDisabled((this.selectedTexture >= this.textures.length - 1 ? 1 : 0) != 0);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.arrowButton((String)"##right", (int)1)) {
            ++this.selectedTexture;
        }
        ImGui.endDisabled();
        ImGui.popButtonRepeat();
        ImGui.beginDisabled((this.downloadFuture != null && !this.downloadFuture.isDone() ? 1 : 0) != 0);
        ImGui.sameLine();
        if (ImGui.button((String)"Download Textures")) {
            this.downloadTextures = true;
            this.downloadFuture = new CompletableFuture();
        }
        ImGui.endDisabled();
        ImGui.beginDisabled((this.openTextures.containsKey(selectedId) && this.openTextures.get((Object)Integer.valueOf((int)selectedId)).visible.get() ? 1 : 0) != 0);
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.button((String)"Pop Out")) {
            this.openTextures.put(selectedId, new OpenTexture(this.flip.get()));
        }
        ImGui.endDisabled();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.checkbox((String)"Flip Y", (ImBoolean)this.flip);
        if (selectedId != 0) {
            TextureEditor.addImage(selectedId, this.flip.get());
        }
    }

    @Override
    public void render() {
        super.render();
        Iterator<Map.Entry<Integer, OpenTexture>> iterator = this.openTextures.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Integer, OpenTexture> entry = iterator.next();
            int id = entry.getKey();
            OpenTexture texture = entry.getValue();
            if (!texture.visible.get()) continue;
            ImBoolean open = texture.open;
            if (!open.get()) {
                open.set(true);
                ImGui.setNextWindowSize((float)800.0f, (float)600.0f);
            }
            if (ImGui.begin((String)("Texture " + id), (ImBoolean)open)) {
                ImBoolean flip = texture.flip;
                ImGui.checkbox((String)"Flip Y", (ImBoolean)flip);
                TextureEditor.addImage(id, flip.get());
            }
            ImGui.end();
            if (open.get()) continue;
            iterator.remove();
        }
    }

    @Override
    public void renderLast() {
        super.renderLast();
        if (this.downloadTextures) {
            this.downloadTextures = false;
            try {
                Minecraft client = Minecraft.getInstance();
                Path outputFolder = Paths.get(client.gameDirectory.toURI()).resolve("debug-out");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                IntIterator intIterator = this.texturesSet.iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    result.add(TextureDownloader.save(Integer.toString(i), outputFolder, i, false));
                }
                this.downloadFuture = CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.getPlatform().openFile(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void renderMenuBar() {
        for (Map.Entry<Integer, OpenTexture> entry : this.openTextures.entrySet()) {
            ImGui.menuItem((String)("Texture " + entry.getKey()), null, (ImBoolean)entry.getValue().visible);
        }
    }

    @Override
    public boolean isMenuBarEnabled() {
        return !this.openTextures.isEmpty();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.texturesSet.clear();
        this.textures = new int[0];
        this.selectedTexture = 0;
    }

    private static void addImage(int selectedId, boolean flip) {
        RenderSystem.bindTexture((int)selectedId);
        int width = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
        int height = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
        float size = ImGui.getContentRegionAvailX();
        ImGui.image((int)selectedId, (float)size, (float)(size * (float)height / (float)width), (float)0.0f, (float)(flip ? 1.0f : 0.0f), (float)1.0f, (float)(flip ? 0.0f : 1.0f), (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private record OpenTexture(ImBoolean open, ImBoolean visible, ImBoolean flip) {
        private OpenTexture(boolean flip) {
            this(new ImBoolean(), new ImBoolean(true), new ImBoolean(flip));
        }
    }
}

