/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.light.AreaLight;
import foundry.veil.api.client.render.deferred.light.DirectionalLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import imgui.ImGui;
import imgui.ImVec4;
import imgui.type.ImBoolean;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import org.joml.Vector3d;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class LightEditor
extends SingleWindowEditor {
    private final Light.Type[] lightTypes = Light.Type.values();

    @Override
    public String getDisplayName() {
        return "Light Editor";
    }

    @Override
    public boolean isEnabled() {
        return VeilRenderSystem.renderer().getDeferredRenderer().isEnabled();
    }

    @Override
    protected void renderComponents() {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer();
        float lineHeight = ImGui.getTextLineHeightWithSpacing();
        ArrayList lights = new ArrayList();
        for (Light.Type lightType : this.lightTypes) {
            lights.addAll(lightRenderer.getLights(lightType));
        }
        if (ImGui.beginTable((String)"##lights", (int)2)) {
            ImGui.tableSetupColumn((String)"     Lights");
            ImGui.tableSetupColumn((String)"Visible", (int)16, (float)(lineHeight * 3.0f));
            ImGui.tableHeadersRow();
            ImGui.indent();
            for (int i = 0; i < lights.size(); ++i) {
                Light light = (Light)lights.get(i);
                boolean visible = light.isVisible(VeilRenderer.getCullingFrustum());
                if (!visible) {
                    ImVec4 textColor = ImGui.getStyle().getColor(0);
                    ImGui.pushStyleColor((int)0, (float)textColor.x, (float)textColor.y, (float)textColor.z, (float)(textColor.w * 0.5f));
                }
                ImGui.tableNextRow();
                ImGui.tableSetColumnIndex((int)0);
                LightEditor.renderLightComponents(light, i);
                ImGui.tableSetColumnIndex((int)1);
                ImBoolean isVisible = new ImBoolean(visible);
                ImGui.checkbox((String)("##visible" + i), (ImBoolean)isVisible);
                if (visible) continue;
                ImGui.popStyleColor();
            }
            ImGui.endTable();
        }
        ImGui.sameLine((float)lineHeight);
        if (ImGui.button((String)"+", (float)lineHeight, (float)lineHeight)) {
            ImGui.openPopup((String)"add_light_popup");
        }
        if (ImGui.isItemHovered((int)0)) {
            ImGui.setTooltip((String)"Add a new light to the world");
        }
        if (ImGui.beginPopup((String)"add_light_popup")) {
            ImGui.text((String)"Choose Light Type:");
            for (Light.Type lightType : this.lightTypes) {
                PointLight light;
                if (!ImGui.selectable((String)lightType.name())) continue;
                switch (lightType) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case POINT: {
                        Light light2 = new PointLight().setRadius(15.0f);
                        break;
                    }
                    case AREA: {
                        Light light2 = new AreaLight().setDistance(15.0f).setOrientation(new Quaternionf().lookAlong((Vector3fc)Minecraft.getInstance().gameRenderer.getMainCamera().getLookVector().mul(-1.0f), (Vector3fc)Minecraft.getInstance().gameRenderer.getMainCamera().getUpVector()));
                        break;
                    }
                    case DIRECTIONAL: {
                        Light light2 = light = new DirectionalLight().setDirection(0.0f, -1.0f, 0.0f);
                    }
                }
                if (light instanceof PositionedLight) {
                    PositionedLight positionedLight = light;
                    Vec3 cameraPos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
                    positionedLight.setPosition(cameraPos.x(), cameraPos.y(), cameraPos.z());
                }
                lightRenderer.addLight(((Light)light).setColor((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)).setBrightness(1.0f));
            }
            ImGui.endPopup();
        }
    }

    private static void renderLightComponents(Light light, int index) {
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer();
        ImBoolean notDeleted = new ImBoolean(true);
        if (ImGui.collapsingHeader((String)(light.getType().name() + "#" + light.hashCode()), (ImBoolean)notDeleted)) {
            LightEditor.renderLightAttributeComponents(light, index);
        }
        if (!notDeleted.get()) {
            lightRenderer.removeLight(light);
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(Light light, int index) {
        Vector3fc lightColor = light.getColor();
        ImFloat editBrightness = new ImFloat(light.getBrightness());
        float[] editLightColor = new float[]{lightColor.x(), lightColor.y(), lightColor.z()};
        ImGui.indent();
        if (ImGui.dragScalar((String)("##brightness" + index), (int)8, (ImFloat)editBrightness, (float)0.02f)) {
            light.setBrightness(editBrightness.get());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"brightness");
        if (ImGui.colorPicker3((String)("##color" + index), (float[])editLightColor)) {
            light.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"color");
        ImGui.newLine();
        switch (light.getType()) {
            case POINT: {
                LightEditor.renderPointLightAttributeComponents((PointLight)light, index);
                break;
            }
            case AREA: {
                LightEditor.renderAreaLightAttributeComponents((AreaLight)light, index);
                break;
            }
            case DIRECTIONAL: {
                LightEditor.renderDirectionalLightAttributeComponents((DirectionalLight)light, index);
            }
        }
        ImGui.unindent();
    }

    private static void renderPointLightAttributeComponents(PointLight light, int index) {
        Vector3d position = light.getPosition();
        ImDouble editX = new ImDouble(position.x());
        ImDouble editY = new ImDouble(position.y());
        ImDouble editZ = new ImDouble(position.z());
        ImFloat editRadius = new ImFloat(light.getRadius());
        ImFloat editFalloff = new ImFloat(light.getFalloff());
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.dragScalar((String)("##x" + index), (int)9, (ImDouble)editX, (float)0.02f)) {
            light.setPosition(editX.get(), position.y(), position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)("##y" + index), (int)9, (ImDouble)editY, (float)0.02f)) {
            light.setPosition(position.x(), editY.get(), position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)("##z" + index), (int)9, (ImDouble)editZ, (float)0.02f)) {
            light.setPosition(position.x(), position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"position");
        if (ImGui.dragScalar((String)("##radius" + index), (int)8, (ImFloat)editRadius, (float)0.02f, (float)0.0f)) {
            light.setRadius(editRadius.get());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"radius");
        if (ImGui.dragScalar((String)("##falloff" + index), (int)8, (ImFloat)editFalloff, (float)0.01f, (float)0.0f)) {
            light.setFalloff(editFalloff.get());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"falloff");
    }

    private static void renderAreaLightAttributeComponents(AreaLight light, int index) {
        Vector2f size = light.getSize();
        Vector3d position = light.getPosition();
        Vector3f orientationAngles = light.getOrientation().getEulerAnglesXYZ(new Vector3f());
        float[] editSize = new float[]{size.x(), size.y()};
        ImDouble editX = new ImDouble(position.x());
        ImDouble editY = new ImDouble(position.y());
        ImDouble editZ = new ImDouble(position.z());
        ImFloat editXRot = new ImFloat(orientationAngles.x() * 57.295776f);
        ImFloat editYRot = new ImFloat(orientationAngles.y() * 57.295776f);
        ImFloat editZRot = new ImFloat(orientationAngles.z() * 57.295776f);
        ImFloat editAngle = new ImFloat(light.getAngle() * 57.295776f);
        ImFloat editDistance = new ImFloat(light.getDistance());
        ImFloat editFalloff = new ImFloat(light.getFalloff());
        if (ImGui.dragFloat2((String)("##size" + index), (float[])editSize, (float)0.02f, (float)1.0E-4f)) {
            light.setSize(editSize[0], editSize[1]);
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"size");
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.dragScalar((String)("##x" + index), (int)9, (ImDouble)editX, (float)0.02f)) {
            light.setPosition(editX.get(), position.y(), position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)("##y" + index), (int)9, (ImDouble)editY, (float)0.02f)) {
            light.setPosition(position.x(), editY.get(), position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)("##z" + index), (int)9, (ImDouble)editZ, (float)0.02f)) {
            light.setPosition(position.x(), position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"position");
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.dragScalar((String)("##xrot" + index), (int)8, (ImFloat)editXRot, (float)0.2f)) {
            light.setOrientation(new Quaternionf().rotationXYZ(editXRot.get() * ((float)Math.PI / 180), orientationAngles.y(), orientationAngles.z()));
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)("##yrot" + index), (int)8, (ImFloat)editYRot, (float)0.2f)) {
            light.setOrientation(new Quaternionf().rotationXYZ(orientationAngles.x(), editYRot.get() * ((float)Math.PI / 180), orientationAngles.z()));
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)("##zrot" + index), (int)8, (ImFloat)editZRot, (float)0.2f)) {
            light.setOrientation(new Quaternionf().rotationXYZ(orientationAngles.x(), orientationAngles.y(), editZRot.get() * ((float)Math.PI / 180)));
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"orientation");
        if (ImGui.dragScalar((String)("##angle" + index), (int)8, (ImFloat)editAngle, (float)0.02f, (float)0.0f, (float)180.0f)) {
            light.setAngle(editAngle.get() * ((float)Math.PI / 180));
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"angle");
        if (ImGui.dragScalar((String)("##distance" + index), (int)8, (ImFloat)editDistance, (float)0.02f, (float)0.0f)) {
            light.setDistance(editDistance.get());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"distance");
        if (ImGui.dragScalar((String)("##falloff" + index), (int)8, (ImFloat)editFalloff, (float)0.01f, (float)0.0f)) {
            light.setFalloff(editFalloff.get());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"falloff");
    }

    private static void renderDirectionalLightAttributeComponents(DirectionalLight light, int index) {
        Vector3f vector;
        Vector3fc direction = light.getDirection();
        float[] editDirection = new float[]{direction.x(), direction.y(), direction.z()};
        if (ImGui.dragFloat3((String)("##direction" + index), (float[])editDirection, (float)0.005f) && !Float.isNaN((vector = new Vector3f(editDirection).normalize()).x()) && !Float.isNaN(vector.y()) && !Float.isNaN(vector.z())) {
            light.setDirection(editDirection[0], editDirection[1], editDirection[2]);
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"direction");
    }
}

