/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.opencl.VeilOpenCL;
import imgui.ImGui;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.openal.AL10;
import org.lwjgl.opengl.GL11C;

@ApiStatus.Internal
public class DeviceInfoViewer
extends SingleWindowEditor {
    private void renderOpenGL() {
        ImGui.text((String)("Vendor: " + GL11C.glGetString((int)7936)));
        ImGui.text((String)("Renderer: " + GL11C.glGetString((int)7937)));
        ImGui.text((String)("Version: " + GL11C.glGetString((int)7938)));
    }

    private void renderOpenAL() {
        ImGui.text((String)("Vendor: " + AL10.alGetString((int)45057)));
        ImGui.text((String)("Renderer: " + AL10.alGetString((int)45059)));
        ImGui.text((String)("Version: " + AL10.alGetString((int)45058)));
    }

    private void renderOpenCL() {
        VeilOpenCL cl = VeilOpenCL.get();
        VeilOpenCL.PlatformInfo[] platforms = cl.getPlatforms();
        ImGui.text((String)"Platforms");
        for (int i = 0; i < platforms.length; ++i) {
            VeilOpenCL.PlatformInfo platform = platforms[i];
            if (!ImGui.collapsingHeader((String)(platform.name() + " (0x%X)".formatted(platform.id())), (int)(i == 0 ? 32 : 0))) continue;
            ImGui.text((String)("Profile: " + platform.profile()));
            ImGui.text((String)("CL Version: " + platform.version()));
            ImGui.text((String)("Vendor: " + platform.vendor()));
            ImGui.separator();
            VeilOpenCL.DeviceInfo[] devices = platform.devices();
            ImGui.text((String)"Devices");
            for (int j = 0; j < devices.length; ++j) {
                VeilOpenCL.DeviceInfo device = devices[i];
                if (!ImGui.collapsingHeader((String)(device.name() + " (0x%X)".formatted(device.id())), (int)(i == 0 ? 32 : 0))) continue;
                String type = device.isCpu() ? "CPU" : (device.isGpu() ? "GPU" : (device.isAccelerator() ? "Accelerator" : "Custom"));
                ImGui.text((String)("Type: " + type));
                ImGui.text((String)"Vendor ID: 0x%X".formatted(device.vendorId()));
                ImGui.text((String)("Max Compute Units: " + device.maxComputeUnits()));
                ImGui.text((String)("Max Work Item Dimensions: " + device.maxWorkItemDimensions()));
                ImGui.text((String)("Max Work Group Size: " + device.maxWorkGroupSize()));
                ImGui.text((String)("Max Clock Frequency: " + device.maxClockFrequency() + " MHz"));
                ImGui.text((String)("Address Size: " + device.addressBits() + " bits"));
                ImGui.text((String)("Available: " + device.available()));
                ImGui.text((String)("Compiler Available: " + device.compilerAvailable()));
                ImGui.separator();
                ImGui.text((String)("Vendor: " + device.vendor()));
                ImGui.text((String)("Version: " + device.version()));
                ImGui.text((String)("Driver Version: " + device.driverVersion()));
                ImGui.text((String)("Profile: " + device.profile()));
                String cVersion = device.openclCVersion();
                if (cVersion == null) continue;
                ImGui.text((String)("OpenCL C Version: " + cVersion));
            }
        }
    }

    @Override
    public String getDisplayName() {
        return "Device Info";
    }

    @Override
    protected void renderComponents() {
        if (ImGui.beginTabBar((String)"##info")) {
            if (ImGui.beginTabItem((String)"OpenCL")) {
                this.renderOpenCL();
                ImGui.endTabItem();
            }
            if (ImGui.beginTabItem((String)"OpenGL")) {
                this.renderOpenGL();
                ImGui.endTabItem();
            }
            if (ImGui.beginTabItem((String)"OpenAL")) {
                this.renderOpenAL();
                ImGui.endTabItem();
            }
            ImGui.endTabBar();
        }
    }

    @Override
    public void render() {
        ImGui.setNextWindowSizeConstraints((float)400.0f, (float)460.0f, (float)Float.MAX_VALUE, (float)Float.MAX_VALUE);
        super.render();
    }
}

