/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.VeilRenderer;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.deferred.light.LightRenderer;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.framebuffer.AdvancedFboTextureAttachment;
import foundry.veil.api.client.render.framebuffer.FramebufferAttachmentDefinition;
import foundry.veil.api.client.render.framebuffer.FramebufferManager;
import foundry.veil.api.client.render.framebuffer.VeilFramebuffers;
import foundry.veil.api.client.render.shader.definition.ShaderPreDefinitions;
import foundry.veil.api.client.util.TextureDownloader;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.opengl.GL11C;

@ApiStatus.Internal
public class DeferredEditor
extends SingleWindowEditor {
    private final ImBoolean enableDeferredPipeline = new ImBoolean();
    private final ImBoolean enableAmbientOcclusion = new ImBoolean();
    private final ImBoolean enableVanillaLight = new ImBoolean();
    private final ImBoolean enableEntityLight = new ImBoolean();
    private final ImBoolean bakeTransparentLight = new ImBoolean();
    private AdvancedFbo downloadBuffer;

    @Override
    public String getDisplayName() {
        return "Deferred Renderer";
    }

    @Override
    protected void renderComponents() {
        VeilRenderer renderer = VeilRenderSystem.renderer();
        ShaderPreDefinitions definitions = renderer.getShaderDefinitions();
        VeilDeferredRenderer deferredRenderer = renderer.getDeferredRenderer();
        LightRenderer lightRenderer = deferredRenderer.getLightRenderer();
        this.enableDeferredPipeline.set(deferredRenderer.getRendererState() != VeilDeferredRenderer.RendererState.DISABLED);
        if (ImGui.checkbox((String)"Enable Pipeline", (ImBoolean)this.enableDeferredPipeline)) {
            if (this.enableDeferredPipeline.get()) {
                deferredRenderer.enable();
            } else {
                deferredRenderer.disable();
            }
        }
        ImGui.sameLine();
        this.enableAmbientOcclusion.set(lightRenderer.isAmbientOcclusionEnabled());
        if (ImGui.checkbox((String)"Enable Ambient Occlusion", (ImBoolean)this.enableAmbientOcclusion)) {
            if (this.enableAmbientOcclusion.get()) {
                lightRenderer.enableAmbientOcclusion();
            } else {
                lightRenderer.disableAmbientOcclusion();
            }
        }
        ImGui.sameLine();
        this.enableVanillaLight.set(lightRenderer.isVanillaLightEnabled());
        if (ImGui.checkbox((String)"Enable Vanilla Light", (ImBoolean)this.enableVanillaLight)) {
            if (this.enableVanillaLight.get()) {
                lightRenderer.enableVanillaLight();
            } else {
                lightRenderer.disableVanillaLight();
            }
        }
        ImGui.sameLine();
        this.enableEntityLight.set(definitions.getDefinition("DISABLE_VANILLA_ENTITY_LIGHT") == null);
        if (ImGui.checkbox((String)"Enable Vanilla Entity Lights", (ImBoolean)this.enableEntityLight)) {
            if (this.enableEntityLight.get()) {
                definitions.remove("DISABLE_VANILLA_ENTITY_LIGHT");
            } else {
                definitions.define("DISABLE_VANILLA_ENTITY_LIGHT");
            }
        }
        ImGui.sameLine();
        this.bakeTransparentLight.set(definitions.getDefinition("USE_BAKED_TRANSPARENT_LIGHTMAPS") != null);
        if (ImGui.checkbox((String)"Bake Transparency Lightmaps", (ImBoolean)this.bakeTransparentLight)) {
            if (this.bakeTransparentLight.get()) {
                definitions.define("USE_BAKED_TRANSPARENT_LIGHTMAPS");
            } else {
                definitions.remove("USE_BAKED_TRANSPARENT_LIGHTMAPS");
            }
        }
        LocalPlayer player = Minecraft.getInstance().player;
        ImGui.sameLine();
        ImGui.beginDisabled((player == null ? 1 : 0) != 0);
        if (ImGui.button((String)"Add Test Light") && player != null) {
            Vec3 pos = player.getEyePosition();
            lightRenderer.addLight(new PointLight().setPosition(pos.x, pos.y, pos.z).setColor((Vector3fc)new Vector3f(1.0f, 1.0f, 1.0f)).setBrightness(5.0f).setRadius(15.0f));
        }
        ImGui.endDisabled();
        ImGui.text((String)"Framebuffers");
        if (ImGui.beginTabBar((String)"Framebuffers")) {
            FramebufferManager framebufferManager = renderer.getFramebufferManager();
            AdvancedFbo deferredBuffer = framebufferManager.getFramebuffer(VeilFramebuffers.DEFERRED);
            AdvancedFbo deferredFinalBuffer = framebufferManager.getFramebuffer(VeilFramebuffers.DEFERRED_FINAL);
            AdvancedFbo transparentBuffer = framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT);
            AdvancedFbo transparentFinalBuffer = framebufferManager.getFramebuffer(VeilFramebuffers.TRANSPARENT_FINAL);
            AdvancedFbo lightBuffer = framebufferManager.getFramebuffer(VeilFramebuffers.LIGHT);
            this.drawBuffers("Opaque", deferredBuffer);
            this.drawBuffers("Opaque Final", deferredFinalBuffer);
            this.drawBuffers("Transparent", transparentBuffer);
            this.drawBuffers("Transparent Final", transparentFinalBuffer);
            this.drawBuffers("Light", lightBuffer);
            ImGui.endTabBar();
        }
    }

    @Override
    public void renderLast() {
        super.renderLast();
        if (this.downloadBuffer != null) {
            try {
                Minecraft client = Minecraft.getInstance();
                Path outputFolder = Paths.get(client.gameDirectory.toURI()).resolve("debug-out").resolve("deferred");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                for (int i = 0; i < this.downloadBuffer.getColorAttachments(); ++i) {
                    if (!this.downloadBuffer.isColorTextureAttachment(i)) continue;
                    AdvancedFboTextureAttachment attachment = this.downloadBuffer.getColorTextureAttachment(i);
                    Object name = attachment.getName() != null ? attachment.getName() : "Attachment " + i;
                    result.add(TextureDownloader.save((String)name, outputFolder, attachment.getId(), true));
                }
                CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.getPlatform().openFile(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.downloadBuffer = null;
        }
    }

    private void drawBuffers(String name, @Nullable AdvancedFbo buffer) {
        ImGui.beginDisabled((buffer == null ? 1 : 0) != 0);
        if (ImGui.beginTabItem((String)name)) {
            if (buffer != null) {
                AdvancedFboTextureAttachment attachment;
                int i;
                if (ImGui.button((String)"Download")) {
                    this.downloadBuffer = buffer;
                }
                int columns = (int)Math.ceil(Math.sqrt(buffer.getColorAttachments() + (buffer.isDepthTextureAttachment() ? 1 : 0)));
                float width = ImGui.getContentRegionAvailX() / (float)columns;
                float height = width * (float)buffer.getHeight() / (float)buffer.getWidth();
                for (i = 0; i < buffer.getColorAttachments(); ++i) {
                    if (!buffer.isColorTextureAttachment(i)) continue;
                    if (i % columns != 0) {
                        ImGui.sameLine();
                    }
                    ImGui.beginGroup();
                    attachment = buffer.getColorTextureAttachment(i);
                    ImGui.text((String)this.getAttachmentName(i, attachment));
                    ImGui.image((int)attachment.getId(), (float)width, (float)height, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ImGui.endGroup();
                }
                if (buffer.isDepthTextureAttachment()) {
                    if (i % columns != 0) {
                        ImGui.sameLine();
                    }
                    ImGui.beginGroup();
                    attachment = buffer.getDepthTextureAttachment();
                    ImGui.text((String)this.getAttachmentName(-1, attachment));
                    ImGui.image((int)attachment.getId(), (float)width, (float)height, (float)0.0f, (float)1.0f, (float)1.0f, (float)0.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    ImGui.endGroup();
                }
            }
            ImGui.endTabItem();
        }
        ImGui.endDisabled();
    }

    private String getAttachmentName(int index, AdvancedFboTextureAttachment attachment) {
        RenderSystem.bindTexture((int)attachment.getId());
        StringBuilder attachmentName = new StringBuilder((String)(attachment.getName() != null ? attachment.getName() : (index == -1 ? "Depth" : "Attachment " + index)));
        int internalFormat = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4099);
        for (FramebufferAttachmentDefinition.Format format : FramebufferAttachmentDefinition.Format.values()) {
            if (internalFormat != format.getInternalId()) continue;
            attachmentName.append(" (").append(format.name()).append(")");
            return attachmentName.toString();
        }
        attachmentName.append(" (0x").append(Integer.toHexString(internalFormat).toUpperCase(Locale.ROOT)).append(")");
        return attachmentName.toString();
    }

    @Override
    public boolean isEnabled() {
        return VeilRenderSystem.renderer().getDeferredRenderer().isEnabled();
    }
}

