/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client;

import foundry.veil.Veil;
import foundry.veil.api.client.imgui.VeilImGui;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.impl.client.InactiveVeilImGuiImpl;
import imgui.ImGui;
import imgui.extension.implot.ImPlot;
import imgui.extension.implot.ImPlotContext;
import imgui.gl3.ImGuiImplGl3;
import imgui.glfw.ImGuiImplGlfw;
import imgui.internal.ImGuiContext;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.glfw.GLFW;

@ApiStatus.Internal
public class VeilImGuiImpl
implements VeilImGui {
    private static VeilImGui instance;
    private final ImGuiImplGlfw implGlfw = new ImGuiImplGlfw();
    private final ImGuiImplGl3 implGl3 = new ImGuiImplGl3();
    private final ImGuiContext imGuiContext = ImGui.createContext();
    private final ImPlotContext imPlotContext = ImPlot.createContext();
    private boolean active;

    private VeilImGuiImpl(long window) {
        this.implGlfw.init(window, true);
        this.implGl3.init("#version 410 core");
    }

    @Override
    public void begin() {
        if (this.active) {
            Veil.LOGGER.error("ImGui failed to render previous frame, disposing");
            ImGui.endFrame();
        }
        this.active = true;
        this.implGlfw.newFrame();
        ImGui.newFrame();
        VeilRenderSystem.renderer().getEditorManager().render();
    }

    @Override
    public void end() {
        if (!this.active) {
            Veil.LOGGER.error("ImGui state de-synced");
            return;
        }
        this.active = false;
        VeilRenderSystem.renderer().getEditorManager().renderLast();
        ImGui.render();
        this.implGl3.renderDrawData(ImGui.getDrawData());
        if (ImGui.getIO().hasConfigFlags(1024)) {
            long backupWindowPtr = GLFW.glfwGetCurrentContext();
            ImGui.updatePlatformWindows();
            ImGui.renderPlatformWindowsDefault();
            GLFW.glfwMakeContextCurrent((long)backupWindowPtr);
        }
    }

    @Override
    public void onGrabMouse() {
        ImGui.setWindowFocus(null);
    }

    @Override
    public boolean mouseButtonCallback(long window, int button, int action, int mods) {
        return ImGui.getIO().getWantCaptureMouse();
    }

    @Override
    public boolean scrollCallback(long window, double xOffset, double yOffset) {
        return ImGui.getIO().getWantCaptureMouse();
    }

    @Override
    public boolean keyCallback(long window, int key, int scancode, int action, int mods) {
        return ImGui.getIO().getWantCaptureKeyboard();
    }

    @Override
    public boolean charCallback(long window, int codepoint) {
        return ImGui.getIO().getWantCaptureKeyboard();
    }

    @Override
    public boolean shouldHideMouse() {
        return ImGui.getIO().getWantCaptureMouse();
    }

    public void free() {
        this.implGlfw.dispose();
        this.implGl3.dispose();
        ImGui.destroyContext((ImGuiContext)this.imGuiContext);
        ImPlot.destroyContext((ImPlotContext)this.imPlotContext);
    }

    public static void init(long window) {
        instance = Veil.IMGUI ? new VeilImGuiImpl(window) : new InactiveVeilImGuiImpl();
    }

    public static VeilImGui get() {
        return instance;
    }
}

