/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl.event;

import com.mojang.logging.LogUtils;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.api.opencl.event.CLEventDispatcher;
import java.nio.IntBuffer;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.lwjgl.opencl.CL10;
import org.lwjgl.system.MemoryStack;
import org.slf4j.Logger;

@ApiStatus.Internal
public class CLLegacyEventDispatcher
implements CLEventDispatcher {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final AtomicInteger WORKER_COUNT = new AtomicInteger(1);
    private final Queue<EventListener> eventListeners = new ConcurrentLinkedQueue<EventListener>();
    private final Object eventNotifier = new Object();
    private final Thread listenerThread = new Thread(this::process, "CL Event Listener #" + WORKER_COUNT.getAndIncrement());
    private volatile boolean stopped;

    public CLLegacyEventDispatcher() {
        this.listenerThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void process() {
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer status = stack.mallocInt(1);
            while (true) {
                EventListener event;
                if ((event = this.eventListeners.poll()) == null) {
                    if (this.stopped) {
                        return;
                    }
                    try {
                        Object object = this.eventNotifier;
                        synchronized (object) {
                            this.eventNotifier.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        LOGGER.warn("Error while waiting for events", (Throwable)e);
                    }
                    continue;
                }
                try {
                    VeilOpenCL.checkCLError(CL10.clGetEventInfo((long)event.event, (int)4563, (IntBuffer)status, null));
                    if ((long)status.get(0) <= event.eventStatus) {
                        event.callback.run();
                        continue;
                    }
                    this.eventListeners.add(event);
                }
                catch (CLException e) {
                    LOGGER.error("Error while querying event", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(long event, long eventStatus, @NotNull Runnable callback) throws CLException {
        Objects.requireNonNull(callback, "callback");
        try (MemoryStack stack = MemoryStack.stackPush();){
            VeilOpenCL.checkCLError(CL10.clGetEventInfo((long)event, (int)4562, (IntBuffer)stack.mallocInt(1), null));
        }
        this.eventListeners.add(new EventListener(event, eventStatus, callback));
        Object object = this.eventNotifier;
        synchronized (object) {
            this.eventNotifier.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        this.stopped = true;
        Object object = this.eventNotifier;
        synchronized (object) {
            this.eventNotifier.notifyAll();
        }
        this.listenerThread.join(4000L);
    }

    private record EventListener(long event, long eventStatus, Runnable callback) {
    }
}

