/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import java.util.Map;

public class CLException
extends Exception {
    private static final Map<Integer, String> ERROR_CODES = Map.ofEntries(Map.entry(-1, "CL_DEVICE_NOT_FOUND"), Map.entry(-2, "CL_DEVICE_NOT_AVAILABLE"), Map.entry(-3, "CL_COMPILER_NOT_AVAILABLE"), Map.entry(-4, "CL_MEM_OBJECT_ALLOCATION_FAILURE"), Map.entry(-5, "CL_OUT_OF_RESOURCES"), Map.entry(-6, "CL_OUT_OF_HOST_MEMORY"), Map.entry(-7, "CL_PROFILING_INFO_NOT_AVAILABLE"), Map.entry(-8, "CL_MEM_COPY_OVERLAP"), Map.entry(-9, "CL_IMAGE_FORMAT_MISMATCH"), Map.entry(-10, "CL_IMAGE_FORMAT_NOT_SUPPORTED"), Map.entry(-11, "CL_BUILD_PROGRAM_FAILURE"), Map.entry(-12, "CL_MAP_FAILURE"), Map.entry(-30, "CL_INVALID_VALUE"), Map.entry(-31, "CL_INVALID_DEVICE_TYPE"), Map.entry(-32, "CL_INVALID_PLATFORM"), Map.entry(-33, "CL_INVALID_DEVICE"), Map.entry(-34, "CL_INVALID_CONTEXT"), Map.entry(-35, "CL_INVALID_QUEUE_PROPERTIES"), Map.entry(-36, "CL_INVALID_COMMAND_QUEUE"), Map.entry(-37, "CL_INVALID_HOST_PTR"), Map.entry(-38, "CL_INVALID_MEM_OBJECT"), Map.entry(-39, "CL_INVALID_IMAGE_FORMAT_DESCRIPTOR"), Map.entry(-40, "CL_INVALID_IMAGE_SIZE"), Map.entry(-41, "CL_INVALID_SAMPLER"), Map.entry(-42, "CL_INVALID_BINARY"), Map.entry(-43, "CL_INVALID_BUILD_OPTIONS"), Map.entry(-44, "CL_INVALID_PROGRAM"), Map.entry(-45, "CL_INVALID_PROGRAM_EXECUTABLE"), Map.entry(-46, "CL_INVALID_KERNEL_NAME"), Map.entry(-47, "CL_INVALID_KERNEL_DEFINITION"), Map.entry(-48, "CL_INVALID_KERNEL"), Map.entry(-49, "CL_INVALID_ARG_INDEX"), Map.entry(-50, "CL_INVALID_ARG_VALUE"), Map.entry(-51, "CL_INVALID_ARG_SIZE"), Map.entry(-52, "CL_INVALID_KERNEL_ARGS"), Map.entry(-53, "CL_INVALID_WORK_DIMENSION"), Map.entry(-54, "CL_INVALID_WORK_GROUP_SIZE"), Map.entry(-55, "CL_INVALID_WORK_ITEM_SIZE"), Map.entry(-56, "CL_INVALID_GLOBAL_OFFSET"), Map.entry(-57, "CL_INVALID_EVENT_WAIT_LIST"), Map.entry(-58, "CL_INVALID_EVENT"), Map.entry(-59, "CL_INVALID_OPERATION"), Map.entry(-61, "CL_INVALID_BUFFER_SIZE"), Map.entry(-63, "CL_INVALID_GLOBAL_WORK_SIZE"));
    private final int error;

    public CLException(String message, int errCode) {
        super(message + ". " + String.format("OpenCL error: %s", ERROR_CODES.getOrDefault(errCode, Integer.toString(errCode))));
        this.error = errCode;
    }

    public CLException(int errCode) {
        super(String.format("OpenCL error: %s", ERROR_CODES.getOrDefault(errCode, Integer.toString(errCode))));
        this.error = errCode;
    }

    public int getError() {
        return this.error;
    }

    public String getErrorString() {
        return ERROR_CODES.getOrDefault(this.error, Integer.toString(this.error));
    }
}

