/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import foundry.veil.api.opencl.VeilOpenCL;
import java.util.function.Function;
import org.lwjgl.opencl.CLCapabilities;

public record CLEnvironmentOptions(CLVersion version, int deviceMask, boolean requireCompiler, boolean requireOpenGL) {
    public static final CLEnvironmentOptions DEFAULT = CLEnvironmentOptions.builder().build();

    public boolean testDevice(VeilOpenCL.DeviceInfo deviceInfo) {
        if ((deviceInfo.type() & (long)this.deviceMask) == 0L) {
            return false;
        }
        if (this.requireCompiler && !deviceInfo.compilerAvailable()) {
            return false;
        }
        if (this.requireOpenGL && !this.version.testGL(deviceInfo.capabilities())) {
            return false;
        }
        return this.version.test(deviceInfo.capabilities());
    }

    public static Builder builder() {
        return new Builder();
    }

    public static enum CLVersion {
        CL10(caps -> caps.OpenCL10, caps -> caps.OpenCL10GL),
        CL11(caps -> caps.OpenCL11),
        CL12(caps -> caps.OpenCL12, caps -> caps.OpenCL12GL),
        CL20(caps -> caps.OpenCL20),
        CL21(caps -> caps.OpenCL21),
        CL22(caps -> caps.OpenCL22),
        CL30(caps -> caps.OpenCL30);

        private final Function<CLCapabilities, Boolean> version;
        private final Function<CLCapabilities, Boolean> glVersion;

        private CLVersion(Function<CLCapabilities, Boolean> version) {
            this(version, version);
        }

        private CLVersion(Function<CLCapabilities, Boolean> version, Function<CLCapabilities, Boolean> glVersion) {
            this.version = version;
            this.glVersion = glVersion;
        }

        public boolean test(CLCapabilities capabilities) {
            return this.version.apply(capabilities);
        }

        public boolean testGL(CLCapabilities capabilities) {
            return this.glVersion.apply(capabilities);
        }
    }

    public static class Builder {
        private CLVersion clVersion = CLVersion.CL12;
        private int deviceMask = -1;
        private boolean requireCompiler = true;
        private boolean requireOpenGL = false;

        public Builder setClVersion(CLVersion clVersion) {
            this.clVersion = clVersion;
            return this;
        }

        public Builder deviceDefault() {
            this.deviceMask = 1;
            return this;
        }

        public Builder deviceGpu() {
            this.deviceMask = 4;
            return this;
        }

        public Builder deviceCpu() {
            this.deviceMask = 2;
            return this;
        }

        public Builder deviceAccelerator() {
            this.deviceMask = 8;
            return this;
        }

        public Builder deviceMask(int deviceMask) {
            this.deviceMask = deviceMask;
            return this;
        }

        public void setRequireCompiler(boolean requireCompiler) {
            this.requireCompiler = requireCompiler;
        }

        public void setRequireGL(boolean requireOpenGL) {
            this.requireOpenGL = requireOpenGL;
        }

        public CLEnvironmentOptions build() {
            return new CLEnvironmentOptions(this.clVersion, this.deviceMask, this.requireCompiler, this.requireOpenGL);
        }
    }
}

