/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.opencl;

import com.mojang.logging.LogUtils;
import foundry.veil.api.opencl.CLException;
import foundry.veil.api.opencl.CLKernel;
import foundry.veil.api.opencl.VeilOpenCL;
import foundry.veil.api.opencl.event.CLEventDispatcher;
import foundry.veil.api.opencl.event.CLLegacyEventDispatcher;
import foundry.veil.api.opencl.event.CLNativeEventDispatcher;
import java.io.IOException;
import java.io.InputStream;
import java.nio.IntBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.PointerBuffer;
import org.lwjgl.opencl.CL10;
import org.lwjgl.opencl.CL20;
import org.lwjgl.opencl.CLContextCallback;
import org.lwjgl.opencl.CLContextCallbackI;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.slf4j.Logger;

public class CLEnvironment
implements NativeResource {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final FileToIdConverter SHADERS = new FileToIdConverter("pinwheel/compute", ".cl");
    private final VeilOpenCL.DeviceInfo device;
    private final CLContextCallback errorCallback;
    private final long context;
    private final long commandQueue;
    private final Map<ResourceLocation, ProgramData> programs;
    private final CLEventDispatcher eventDispatcher;

    public CLEnvironment(VeilOpenCL.DeviceInfo deviceInfo) throws CLException {
        this.device = deviceInfo;
        try (MemoryStack stack = MemoryStack.stackPush();){
            PointerBuffer ctxProps = stack.mallocPointer(3);
            ctxProps.put(0, 4228L).put(1, deviceInfo.platform()).put(2, 0L);
            long device = deviceInfo.id();
            this.errorCallback = CLContextCallback.create((errinfo, private_info, cb, user_data) -> {
                VeilOpenCL.LOGGER.error("[LWJGL] cl_context_callback");
                VeilOpenCL.LOGGER.error("\tInfo: " + MemoryUtil.memUTF8((long)errinfo));
            });
            IntBuffer errcode_ret = stack.callocInt(1);
            try {
                this.context = CL10.clCreateContext((PointerBuffer)ctxProps, (long)device, (CLContextCallbackI)this.errorCallback, (long)0L, (IntBuffer)errcode_ret);
                VeilOpenCL.checkCLError(errcode_ret);
                this.commandQueue = CL20.clCreateCommandQueueWithProperties((long)this.context, (long)device, null, (IntBuffer)errcode_ret);
                VeilOpenCL.checkCLError(errcode_ret);
                if (this.commandQueue == 0L) {
                    throw new IllegalStateException("Failed to create OpenCL queue");
                }
            }
            catch (Exception e) {
                this.free();
                throw e;
            }
        }
        this.programs = new HashMap<ResourceLocation, ProgramData>();
        this.eventDispatcher = deviceInfo.capabilities().clSetEventCallback != 0L ? new CLNativeEventDispatcher() : new CLLegacyEventDispatcher();
    }

    public void loadProgram(ResourceLocation name, CharSequence source) {
        try (MemoryStack stack = MemoryStack.stackPush();){
            long program = 0L;
            IntBuffer errcode_ret = stack.callocInt(1);
            try {
                program = CL10.clCreateProgramWithSource((long)this.context, (CharSequence)source, (IntBuffer)errcode_ret);
                VeilOpenCL.checkCLError(errcode_ret);
                long device = this.device.id();
                int programStatus = CL10.clBuildProgram((long)program, (long)device, (CharSequence)"", null, (long)0L);
                if (programStatus != 0) {
                    System.err.println(VeilOpenCL.getProgramBuildInfo(program, device, 4483));
                    throw new CLException("Failed to compile program", programStatus);
                }
                ProgramData oldProgram = this.programs.put(name, new ProgramData(program));
                if (oldProgram != null) {
                    LOGGER.info("Deleting old program: {}", (Object)name);
                    oldProgram.free();
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to load program from source: {}", (Object)name, (Object)e);
                if (program != 0L) {
                    CL10.clReleaseProgram((long)program);
                }
            }
        }
    }

    public void loadProgram(ResourceLocation name, ResourceProvider provider) throws IOException {
        Resource resource = provider.getResourceOrThrow(SHADERS.idToFile(name));
        try (InputStream stream = resource.open();){
            this.loadProgram(name, IOUtils.toString((InputStream)stream, (Charset)StandardCharsets.UTF_8));
        }
    }

    public CLKernel createKernel(ResourceLocation program, String kernelName) throws CLException {
        ProgramData programData = this.programs.get(program);
        if (programData == null) {
            throw new CLException("Unknown program: " + kernelName, -44);
        }
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer errcode_ret = stack.callocInt(1);
            long kernelId = CL10.clCreateKernel((long)programData.id, (CharSequence)kernelName, (IntBuffer)errcode_ret);
            if (errcode_ret.get(0) == -46) {
                throw new CLException("Failed to find kernel: " + kernelName, errcode_ret.get(0));
            }
            VeilOpenCL.checkCLError(errcode_ret);
            CLKernel kernel = new CLKernel(this, program, kernelId);
            programData.kernels.add(kernel);
            CLKernel cLKernel = kernel;
            return cLKernel;
        }
    }

    public void finish() throws CLException {
        VeilOpenCL.checkCLError(CL10.clFinish((long)this.commandQueue));
    }

    public void freeProgram(ResourceLocation program) {
        ProgramData programData = this.programs.remove(program);
        if (programData != null) {
            LOGGER.info("Deleting kernel program: {}", (Object)program);
            programData.free();
        }
    }

    @ApiStatus.Internal
    public void free() {
        try {
            this.finish();
        }
        catch (CLException cLException) {
            // empty catch block
        }
        if (this.errorCallback != null) {
            this.errorCallback.free();
        }
        if (this.commandQueue != 0L) {
            CL10.clReleaseCommandQueue((long)this.commandQueue);
        }
        if (this.context != 0L) {
            CL10.clReleaseContext((long)this.context);
        }
        this.programs.values().forEach(NativeResource::free);
        this.programs.clear();
        CLEventDispatcher cLEventDispatcher = this.eventDispatcher;
        if (cLEventDispatcher instanceof CLLegacyEventDispatcher) {
            CLLegacyEventDispatcher legacyEventDispatcher = (CLLegacyEventDispatcher)cLEventDispatcher;
            try {
                legacyEventDispatcher.close();
            }
            catch (InterruptedException e) {
                LOGGER.error("Failed to stop event dispatcher", (Throwable)e);
            }
        }
    }

    @ApiStatus.Internal
    void free(CLKernel clKernel) {
        ResourceLocation name = clKernel.getProgram();
        ProgramData programData = this.programs.get(name);
        if (programData == null) {
            return;
        }
        programData.kernels.remove(clKernel);
        if (programData.kernels.isEmpty()) {
            this.freeProgram(name);
        }
    }

    public VeilOpenCL.DeviceInfo getDevice() {
        return this.device;
    }

    public CLEventDispatcher getEventDispatcher() {
        return this.eventDispatcher;
    }

    public long getContext() {
        return this.context;
    }

    public long getCommandQueue() {
        return this.commandQueue;
    }

    private record ProgramData(long id, Set<CLKernel> kernels) implements NativeResource
    {
        private ProgramData(long id) {
            this(id, new HashSet<CLKernel>());
        }

        public void free() {
            CL10.clReleaseProgram((long)this.id);
            this.kernels.clear();
        }
    }
}

