/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.texture;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.texture.FramebufferSource;
import foundry.veil.api.client.render.shader.texture.LocationSource;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public interface ShaderTextureSource {
    public static final Codec<Type> TYPE_CODEC = Codec.STRING.flatXmap(name -> Optional.ofNullable(Type.byName(name)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown post texture source: " + name)), object -> DataResult.success((Object)object.name().toLowerCase(Locale.ROOT)));
    public static final Codec<ShaderTextureSource> CODEC = Codec.either((Codec)ResourceLocation.CODEC, (Codec)TYPE_CODEC.dispatch(ShaderTextureSource::getType, Type::getCodec)).xmap(either -> (ShaderTextureSource)either.map(LocationSource::new, right -> right), source -> {
        Either either;
        if (source instanceof LocationSource) {
            LocationSource l = (LocationSource)source;
            either = Either.left((Object)l.location());
        } else {
            either = Either.right((Object)source);
        }
        return either;
    });
    public static final Context GLOBAL_CONTEXT = new Context(){

        @Override
        @Nullable
        public AdvancedFbo getFramebuffer(ResourceLocation name) {
            return VeilRenderSystem.renderer().getFramebufferManager().getFramebuffer(name);
        }

        @Override
        public AbstractTexture getTexture(ResourceLocation name) {
            return Minecraft.getInstance().getTextureManager().getTexture(name);
        }
    };

    public int getId(Context var1);

    public Type getType();

    public static enum Type {
        LOCATION(LocationSource.CODEC),
        FRAMEBUFFER(FramebufferSource.CODEC);

        private final Codec<? extends ShaderTextureSource> codec;

        private Type(Codec<? extends ShaderTextureSource> codec) {
            this.codec = codec;
        }

        public Codec<? extends ShaderTextureSource> getCodec() {
            return this.codec;
        }

        @Nullable
        public static Type byName(String name) {
            for (Type type : Type.values()) {
                if (!type.name().toLowerCase(Locale.ROOT).equals(name)) continue;
                return type;
            }
            return null;
        }
    }

    public static interface Context {
        @Nullable
        public AdvancedFbo getFramebuffer(ResourceLocation var1);

        public AbstractTexture getTexture(ResourceLocation var1);
    }
}

