/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.program;

import com.google.common.collect.Iterables;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.api.client.render.shader.texture.ShaderTextureSource;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.jetbrains.annotations.Nullable;

public record ProgramDefinition(@Nullable ResourceLocation vertex, @Nullable ResourceLocation tesselationControl, @Nullable ResourceLocation tesselationEvaluation, @Nullable ResourceLocation geometry, @Nullable ResourceLocation fragment, @Nullable ResourceLocation compute, String[] definitions, Map<String, String> definitionDefaults, Map<String, ShaderTextureSource> textures, Map<Integer, ResourceLocation> shaders) {

    public static class Deserializer
    implements JsonDeserializer<ProgramDefinition> {
        private String[] deserializeDefinitions(JsonArray json, Map<String, String> defaults) throws JsonParseException {
            ArrayList<String> definitions = new ArrayList<String>(json.size());
            for (int i = 0; i < json.size(); ++i) {
                JsonElement element = json.get(i);
                if (element.isJsonPrimitive()) {
                    definitions.add(element.getAsJsonPrimitive().getAsString());
                    continue;
                }
                if (element.isJsonObject()) {
                    JsonObject definitionJson = element.getAsJsonObject();
                    Set entrySet = definitionJson.entrySet();
                    if (entrySet.size() != 1) {
                        throw new JsonSyntaxException("Expected definitions[" + i + "] to have one element, had " + entrySet.size());
                    }
                    Map.Entry entry = (Map.Entry)Iterables.getOnlyElement((Iterable)entrySet);
                    definitions.add((String)entry.getKey());
                    defaults.put((String)entry.getKey(), GsonHelper.convertToString((JsonElement)((JsonElement)entry.getValue()), (String)("definitions[" + i + "]")));
                    continue;
                }
                throw new JsonSyntaxException("Expected definitions[" + i + "] to be a JsonPrimitive or Object, was " + GsonHelper.getType((JsonElement)element));
            }
            return (String[])definitions.toArray(String[]::new);
        }

        private Map<String, ShaderTextureSource> deserializeTextures(JsonObject json) throws JsonParseException {
            HashMap<String, ShaderTextureSource> textures = new HashMap<String, ShaderTextureSource>();
            for (Map.Entry entry : json.entrySet()) {
                String name = (String)entry.getKey();
                DataResult texture = ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
                if (texture.error().isPresent()) {
                    throw new JsonSyntaxException("Failed to deserialize texture: " + name + ". " + ((DataResult.PartialResult)texture.error().get()).message());
                }
                textures.put(name, (ShaderTextureSource)texture.result().orElseThrow());
            }
            ShaderTextureSource.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            return Collections.unmodifiableMap(textures);
        }

        public ProgramDefinition deserialize(JsonElement element, Type type, JsonDeserializationContext context) throws JsonParseException {
            Map<String, String> definitionDefaults;
            String[] definitions;
            JsonObject json = element.getAsJsonObject();
            ResourceLocation vertex = (ResourceLocation)context.deserialize(json.get("vertex"), ResourceLocation.class);
            ResourceLocation tesselationControl = (ResourceLocation)context.deserialize(json.get("tesselation_control"), ResourceLocation.class);
            ResourceLocation tesselationEvaluation = (ResourceLocation)context.deserialize(json.get("tesselation_evaluation"), ResourceLocation.class);
            ResourceLocation geometry = (ResourceLocation)context.deserialize(json.get("geometry"), ResourceLocation.class);
            ResourceLocation fragment = (ResourceLocation)context.deserialize(json.get("fragment"), ResourceLocation.class);
            ResourceLocation compute = (ResourceLocation)context.deserialize(json.get("compute"), ResourceLocation.class);
            if (json.has("definitions")) {
                HashMap<String, String> defaults = new HashMap<String, String>();
                definitions = this.deserializeDefinitions(json.getAsJsonArray("definitions"), defaults);
                definitionDefaults = Collections.unmodifiableMap(defaults);
            } else {
                definitions = new String[]{};
                definitionDefaults = Collections.emptyMap();
            }
            Map<String, ShaderTextureSource> textures = json.has("textures") ? this.deserializeTextures(json.getAsJsonObject("textures")) : Collections.emptyMap();
            HashMap<Integer, ResourceLocation> sources = new HashMap<Integer, ResourceLocation>();
            if (vertex != null) {
                sources.put(35633, vertex);
            }
            if (tesselationControl != null) {
                sources.put(36488, tesselationControl);
            }
            if (tesselationEvaluation != null) {
                sources.put(36487, tesselationEvaluation);
            }
            if (geometry != null) {
                sources.put(36313, geometry);
            }
            if (fragment != null) {
                sources.put(35632, fragment);
            }
            if (compute != null) {
                sources.put(37305, compute);
            }
            return new ProgramDefinition(vertex, tesselationControl, tesselationEvaluation, geometry, fragment, compute, definitions, definitionDefaults, textures, Collections.unmodifiableMap(sources));
        }
    }
}

