/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader.processor;

import foundry.veil.api.client.render.shader.ShaderManager;
import foundry.veil.api.client.render.shader.ShaderModificationManager;
import foundry.veil.api.client.render.shader.processor.ShaderPreProcessor;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;

public class ShaderModifyProcessor
implements ShaderPreProcessor {
    private final ShaderModificationManager shaderModificationManager;
    private final Set<ResourceLocation> appliedModifications;

    public ShaderModifyProcessor(ShaderModificationManager shaderModificationManager) {
        this.shaderModificationManager = shaderModificationManager;
        this.appliedModifications = new HashSet<ResourceLocation>();
    }

    @Override
    public void prepare() {
        this.appliedModifications.clear();
    }

    @Override
    public String modify(ShaderPreProcessor.Context context) throws IOException {
        ResourceLocation name = context.getName();
        if (name == null || !this.appliedModifications.add(name)) {
            return context.getInput();
        }
        int flags = context.isSourceFile() ? 3 : 0;
        FileToIdConverter converter = context.isSourceFile() ? context.getConverter() : ShaderManager.INCLUDE_LISTER;
        return context.modify(context.getName(), this.shaderModificationManager.applyModifiers(converter.idToFile(name), context.getInput(), flags));
    }
}

