/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import java.util.Map;
import net.minecraft.resources.FileToIdConverter;

public final class ShaderSourceSet {
    private final String folder;
    private final FileToIdConverter shaderDefinitionLister;
    private final FileToIdConverter glslConverter;
    private final Map<Integer, FileToIdConverter> typeConverters;

    public ShaderSourceSet(String folder) {
        this.folder = folder;
        this.shaderDefinitionLister = FileToIdConverter.json((String)folder);
        this.glslConverter = new FileToIdConverter(folder, ".glsl");
        this.typeConverters = Map.of(35633, new FileToIdConverter(folder, ".vsh"), 36488, new FileToIdConverter(folder, ".tcsh"), 36487, new FileToIdConverter(folder, ".tesh"), 36313, new FileToIdConverter(folder, ".gsh"), 35632, new FileToIdConverter(folder, ".fsh"), 37305, new FileToIdConverter(folder, ".csh"));
    }

    public String getFolder() {
        return this.folder;
    }

    public FileToIdConverter getShaderDefinitionLister() {
        return this.shaderDefinitionLister;
    }

    public FileToIdConverter getGlslConverter() {
        return this.glslConverter;
    }

    public FileToIdConverter getTypeConverter(int type) {
        return this.typeConverters.getOrDefault(type, this.glslConverter);
    }
}

