/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.shader;

import com.mojang.logging.LogUtils;
import foundry.veil.Veil;
import foundry.veil.impl.client.render.shader.modifier.InputShaderModification;
import foundry.veil.impl.client.render.shader.modifier.ReplaceShaderModification;
import foundry.veil.impl.client.render.shader.modifier.ShaderModification;
import foundry.veil.impl.client.render.shader.modifier.SimpleShaderModification;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.StringUtil;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.commons.io.IOUtils;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ShaderModificationManager
extends SimplePreparableReloadListener<Preparations> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final FileToIdConverter MODIFIER_LISTER = new FileToIdConverter("pinwheel/shader_modifiers", ".txt");
    private static final Map<String, String> NEXT_STAGES = Map.of("vsh", "gsh", "gsh", "fsh");
    private static final Pattern OUT_PATTERN = Pattern.compile("out ");
    private Map<ResourceLocation, List<ShaderModification>> shaders = Collections.emptyMap();
    private Map<ShaderModification, ResourceLocation> names;

    public String applyModifiers(ResourceLocation shaderId, String source, int flags) {
        for (ShaderModification modification : this.getModifiers(shaderId)) {
            try {
                source = modification.inject(source, flags);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to apply modification {} to shader instance {}. Skipping", new Object[]{this.names.get(modification), shaderId, e});
            }
        }
        return source;
    }

    public Collection<ShaderModification> getModifiers(ResourceLocation shaderId) {
        return this.shaders.getOrDefault(shaderId, Collections.emptyList());
    }

    @Nullable
    private ResourceLocation getNextStage(ResourceLocation shader, ResourceProvider resourceProvider) {
        String[] parts = shader.getPath().split("\\.");
        String extension = parts[parts.length - 1].toLowerCase(Locale.ROOT);
        while (extension != null) {
            extension = NEXT_STAGES.get(extension);
            ResourceLocation nextShader = new ResourceLocation(shader.getNamespace(), shader.getPath().substring(0, shader.getPath().length() - 3) + extension);
            if (!resourceProvider.getResource(nextShader).isPresent()) continue;
            return nextShader;
        }
        return null;
    }

    @NotNull
    protected Preparations prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, List<ShaderModification>> modifiers = new HashMap<ResourceLocation, List<ShaderModification>>();
        HashMap<ShaderModification, ResourceLocation> names = new HashMap<ShaderModification, ResourceLocation>();
        for (Map.Entry entry : MODIFIER_LISTER.listMatchingResources(resourceManager).entrySet()) {
            ResourceLocation file = (ResourceLocation)entry.getKey();
            ResourceLocation id = MODIFIER_LISTER.fileToId(file);
            try {
                String[] parts = id.getPath().split("/", 2);
                if (parts.length < 2) {
                    LOGGER.warn("Ignoring shader modifier {}. Expected format to be located in shader_modifiers/domain/shader_path.vsh.txt", (Object)file);
                    continue;
                }
                ResourceLocation shaderId = new ResourceLocation(parts[0], parts[1]);
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    ShaderModification modification = ShaderModification.parse(IOUtils.toString((Reader)reader), shaderId.getPath().endsWith(".vsh"));
                    List modifications2 = modifiers.computeIfAbsent(shaderId, name -> new LinkedList());
                    if (modification instanceof ReplaceShaderModification) {
                        modifications2.clear();
                    }
                    if (modifications2.size() != 1 || !(modifications2.get(0) instanceof ReplaceShaderModification)) {
                        modifications2.add(modification);
                    }
                    names.put(modification, id);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, file, e});
            }
        }
        block8: for (Map.Entry entry : new HashMap(modifiers).entrySet()) {
            ResourceLocation nextStage = null;
            for (ShaderModification modification : (List)entry.getValue()) {
                SimpleShaderModification simpleMod;
                String output;
                if (!(modification instanceof SimpleShaderModification) || StringUtil.isNullOrEmpty((String)(output = (simpleMod = (SimpleShaderModification)modification).getOutput()))) continue;
                if (nextStage == null) {
                    nextStage = this.getNextStage((ResourceLocation)entry.getKey(), (ResourceProvider)resourceManager);
                }
                if (nextStage == null) continue block8;
                InputShaderModification input = new InputShaderModification(simpleMod.getPriority(), () -> OUT_PATTERN.matcher(simpleMod.fillPlaceholders(simpleMod.getOutput())).replaceAll("in "));
                modifiers.computeIfAbsent(nextStage, unused -> new LinkedList()).add(input);
                names.put(input, (ResourceLocation)names.get(simpleMod));
            }
        }
        modifiers.values().forEach(modifications -> modifications.sort(Comparator.comparingInt(ShaderModification::getPriority).thenComparing(names::get)));
        return new Preparations(modifiers, names);
    }

    protected void apply(@NotNull Preparations preparations, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        this.shaders = Collections.unmodifiableMap(preparations.shaders);
        this.names = Collections.unmodifiableMap(preparations.names);
        LOGGER.info("Loaded {} shader modifications", (Object)this.names.size());
    }

    @ApiStatus.Internal
    public record Preparations(Map<ResourceLocation, List<ShaderModification>> shaders, Map<ShaderModification, ResourceLocation> names) {
    }
}

