/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.framebuffer;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFboAttachment;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL30;

public class AdvancedFboRenderAttachment
implements AdvancedFboAttachment {
    public static final int MAX_SAMPLES = GL30.glGetInteger((int)36183);
    private int id;
    private final int attachmentType;
    private final int attachmentFormat;
    private final int width;
    private final int height;
    private final int samples;

    public AdvancedFboRenderAttachment(int attachmentType, int attachmentFormat, int width, int height, int samples) {
        this.attachmentType = attachmentType;
        this.attachmentFormat = attachmentFormat;
        this.width = width;
        this.height = height;
        Validate.inclusiveBetween((long)1L, (long)MAX_SAMPLES, (long)samples);
        this.samples = samples;
    }

    @Override
    public void create() {
        this.bindAttachment();
        if (this.samples == 1) {
            GL30.glRenderbufferStorage((int)36161, (int)this.attachmentFormat, (int)this.width, (int)this.height);
        } else {
            GL30.glRenderbufferStorageMultisample((int)36161, (int)this.samples, (int)this.attachmentFormat, (int)this.width, (int)this.height);
        }
        this.unbindAttachment();
    }

    @Override
    public void attach(int target, int attachment) {
        Validate.isTrue((this.attachmentType != 36096 || attachment == 0 ? 1 : 0) != 0, (String)"Only one depth buffer attachment is supported.", (Object[])new Object[0]);
        GL30.glFramebufferRenderbuffer((int)target, (int)this.attachmentType, (int)36161, (int)this.getId());
    }

    @Override
    public void bindAttachment() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)this.getId()));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)this.getId());
        }
    }

    @Override
    public void unbindAttachment() {
        if (!RenderSystem.isOnRenderThreadOrInit()) {
            RenderSystem.recordRenderCall(() -> GL30.glBindRenderbuffer((int)36161, (int)0));
        } else {
            GL30.glBindRenderbuffer((int)36161, (int)0);
        }
    }

    public int getId() {
        RenderSystem.assertOnRenderThreadOrInit();
        if (this.id == 0) {
            this.id = GL30.glGenRenderbuffers();
        }
        return this.id;
    }

    @Override
    public int getAttachmentType() {
        return this.attachmentType;
    }

    @Override
    public int getFormat() {
        return this.attachmentFormat;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getLevels() {
        return this.samples;
    }

    @Override
    public boolean canSample() {
        return false;
    }

    @Override
    @Nullable
    public String getName() {
        return null;
    }

    @Override
    @NotNull
    public AdvancedFboAttachment createCopy() {
        return new AdvancedFboRenderAttachment(this.attachmentType, this.attachmentFormat, this.width, this.height, this.samples);
    }

    public void free() {
        if (this.id != 0) {
            GL30.glDeleteRenderbuffers((int)this.id);
        }
        this.id = 0;
    }
}

