/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.render.CullFrustum;
import foundry.veil.api.client.render.deferred.light.LightTypeRenderer;
import foundry.veil.impl.client.render.deferred.light.AreaLightRenderer;
import foundry.veil.impl.client.render.deferred.light.DirectionalLightRenderer;
import foundry.veil.impl.client.render.deferred.light.PointLightRenderer;
import java.util.function.Supplier;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class Light
implements Cloneable {
    protected final Vector3f color = new Vector3f(1.0f);
    protected float brightness = 1.0f;
    private boolean dirty;

    public Light() {
        this.markDirty();
    }

    public abstract boolean isVisible(CullFrustum var1);

    public void markDirty() {
        this.dirty = true;
    }

    public void clean() {
        this.dirty = false;
    }

    public Vector3fc getColor() {
        return this.color;
    }

    public int getColorInt() {
        int red = (int)(this.color.x() / 255.0f) & 0xFF;
        int green = (int)(this.color.y() / 255.0f) & 0xFF;
        int blue = (int)(this.color.z() / 255.0f) & 0xFF;
        return red << 16 | green << 8 | blue;
    }

    public Light setColor(Vector3fc color) {
        return this.setColor(color.x(), color.y(), color.z());
    }

    public Light setColor(float red, float green, float blue) {
        this.color.set(red, green, blue);
        this.markDirty();
        return this;
    }

    public Light setColor(int color) {
        this.color.set((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f);
        this.markDirty();
        return this;
    }

    public Light setBrightness(float brightness) {
        this.brightness = brightness;
        this.markDirty();
        return this;
    }

    public float getBrightness() {
        return this.brightness;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public abstract Type getType();

    public abstract Light clone();

    public static enum Type {
        DIRECTIONAL(DirectionalLightRenderer::new),
        POINT(PointLightRenderer::new),
        AREA(AreaLightRenderer::new);

        private final Supplier<LightTypeRenderer<?>> rendererFactory;

        private Type(Supplier<LightTypeRenderer<?>> rendererFactory) {
            this.rendererFactory = rendererFactory;
        }

        public LightTypeRenderer<?> createRenderer() {
            return this.rendererFactory.get();
        }
    }
}

