/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.registry;

import foundry.veil.api.client.pose.ExtendedPose;
import foundry.veil.api.client.util.Easings;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.TridentItem;

public class PoseRegistry {
    public static Map<Predicate<Item>, ExtendedPose> poses = new HashMap<Predicate<Item>, ExtendedPose>();
    public static ExtendedPose BOW = PoseRegistry.registerPose((Item item) -> item instanceof BowItem, new ExtendedPose(){

        @Override
        public void poseMainHand(ModelPart mainHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            mainHand.xRot *= mult;
        }

        @Override
        public void poseOffHand(ModelPart offHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            offHand.xRot *= mult;
        }
    });
    public static ExtendedPose CROSSBOW = PoseRegistry.registerPose((Item i) -> i instanceof CrossbowItem, new ExtendedPose(){

        @Override
        public void poseMainHand(ModelPart mainHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            mainHand.xRot *= mult;
        }

        @Override
        public void poseOffHand(ModelPart offHand) {
            float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
            mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
            offHand.xRot *= mult;
        }
    });
    public static ExtendedPose TRIDENT = PoseRegistry.registerPose((Item i) -> i instanceof TridentItem, new ExtendedPose(){
        float headXRot = 0.0f;
        float headYRot = 0.0f;
        public final boolean forceRenderOffhand = true;

        @Override
        public void pose(HumanoidModel<?> model) {
            super.pose(model);
            this.headXRot = model.head.xRot;
            this.headYRot = model.head.yRot;
        }

        @Override
        public void poseBody(ModelPart body) {
            body.xRot = -0.75f + Math.max(0.0f, 1.5707964f + this.headXRot) / 2.0f;
        }

        @Override
        public void poseMainHand(ModelPart mainHand) {
            if (this.data.swapped) {
                mainHand.yRot = 0.1f + this.headYRot;
                mainHand.xRot = -1.5707964f + this.headXRot;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                mainHand.xRot *= mult;
                mainHand.yRot *= mult;
            } else {
                mainHand.xRot = -1.5707964f + this.headXRot - 1.5f;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                if (!Minecraft.getInstance().player.isShiftKeyDown()) {
                    mainHand.xRot *= mult;
                    return;
                }
                mainHand.xRot *= mult / 2.0f;
                mainHand.yRot = 1.25f + this.headYRot;
                if (this.data.useTime >= this.data.maxUseTime) {
                    mainHand.yRot += (float)(Math.sin((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                    mainHand.xRot += (float)(Math.cos((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                }
            }
        }

        @Override
        public void poseOffHand(ModelPart offHand) {
            if (this.data.swapped) {
                offHand.xRot = -1.5707964f + this.headXRot - 1.5f;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                if (!Minecraft.getInstance().player.isShiftKeyDown()) {
                    offHand.xRot *= mult;
                    return;
                }
                offHand.xRot *= mult / 2.0f;
                offHand.yRot = 1.25f + this.headYRot;
                if (this.data.useTime >= this.data.maxUseTime) {
                    offHand.yRot += (float)(Math.sin((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                    offHand.xRot += (float)(Math.cos((this.data.useTime + this.data.partialTick) / 2.0f) * 0.5);
                }
            } else {
                offHand.yRot = 0.1f + this.headYRot;
                offHand.xRot = -1.5707964f + this.headXRot;
                float mult = Math.min(this.data.useTime + this.data.partialTick, this.data.maxUseTime) / this.data.maxUseTime;
                mult = Easings.ease(mult, Easings.Easing.easeInOutSine);
                offHand.xRot *= mult;
                offHand.yRot *= mult;
            }
        }
    });

    public static ExtendedPose registerPose(Item item, ExtendedPose pose) {
        poses.put(i -> i.equals(item), pose);
        return pose;
    }

    public static ExtendedPose registerPose(Predicate<Item> itemPredicate, ExtendedPose pose) {
        poses.put(itemPredicate, pose);
        return pose;
    }
}

