/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.anim;

import foundry.veil.api.client.util.Easings;
import net.minecraft.world.phys.Vec3;

public class Frame {
    Vec3 position;
    Vec3 rotation;
    Vec3 scale;

    public Frame(Vec3 position, Vec3 rotation, Vec3 scale) {
        this.position = position;
        this.rotation = rotation;
        this.scale = scale;
    }

    public Vec3 getPosition() {
        return this.position;
    }

    public Vec3 getRotation() {
        return this.rotation;
    }

    public Vec3 getScale() {
        return this.scale;
    }

    public Frame copy() {
        return new Frame(this.position, this.rotation, this.scale);
    }

    public Frame interpolate(Frame frame, float progress, Easings.Easing easing) {
        Vec3 position = this.position.add(frame.position.subtract(this.position).scale((double)easing.ease(progress)));
        Vec3 rotation = this.rotation.add(frame.rotation.subtract(this.rotation).scale((double)easing.ease(progress)));
        Vec3 scale = this.scale.add(frame.scale.subtract(this.scale).scale((double)easing.ease(progress)));
        return new Frame(position, rotation, scale);
    }

    public Frame bezierInterpolate(Frame frame, float progress, Easings.Easing easing) {
        Vec3 p0 = this.position;
        Vec3 p1 = this.position.add(this.rotation);
        Vec3 p2 = frame.position.add(frame.rotation);
        Vec3 p3 = frame.position;
        Vec3 position = p0.scale((double)((float)Math.pow(1.0f - progress, 3.0))).add(p1.scale((double)(3.0f * progress * (float)Math.pow(1.0f - progress, 2.0)))).add(p2.scale((double)(3.0f * (float)Math.pow(progress, 2.0) * (1.0f - progress)))).add(p3.scale((double)((float)Math.pow(progress, 3.0))));
        Vec3 r0 = this.rotation;
        Vec3 r1 = this.rotation.add(this.scale);
        Vec3 r2 = frame.rotation.add(frame.scale);
        Vec3 r3 = frame.rotation;
        Vec3 rotation = r0.scale((double)((float)Math.pow(1.0f - progress, 3.0))).add(r1.scale((double)(3.0f * progress * (float)Math.pow(1.0f - progress, 2.0)))).add(r2.scale((double)(3.0f * (float)Math.pow(progress, 2.0) * (1.0f - progress)))).add(r3.scale((double)((float)Math.pow(progress, 3.0))));
        Vec3 s0 = this.scale;
        Vec3 s1 = this.scale.add(this.position);
        Vec3 s2 = frame.scale.add(frame.position);
        Vec3 s3 = frame.scale;
        Vec3 scale = s0.scale((double)((float)Math.pow(1.0f - progress, 3.0))).add(s1.scale((double)(3.0f * progress * (float)Math.pow(1.0f - progress, 2.0)))).add(s2.scale((double)(3.0f * (float)Math.pow(progress, 2.0) * (1.0f - progress)))).add(s3.scale((double)((float)Math.pow(progress, 3.0))));
        return new Frame(position, rotation, scale);
    }
}

