/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.BufferBuilder;
import foundry.veil.ext.LevelRendererBlockLayerExtension;
import foundry.veil.mixin.accessor.RenderBuffersAccessor;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="veil", value={Dist.CLIENT})
@ApiStatus.Internal
public class ForgeRenderTypeStageHandler {
    private static final Map<RenderLevelStageEvent.Stage, Set<RenderType>> STAGE_RENDER_TYPES = new HashMap<RenderLevelStageEvent.Stage, Set<RenderType>>();
    private static Set<RenderType> CUSTOM_BLOCK_LAYERS;
    private static List<RenderType> BLOCK_LAYERS;

    public static synchronized void register(@Nullable RenderLevelStageEvent.Stage stage, RenderType renderType) {
        SortedMap<RenderType, BufferBuilder> fixedBuffers = ((RenderBuffersAccessor)Minecraft.m_91087_().m_91269_()).getFixedBuffers();
        fixedBuffers.computeIfAbsent(renderType, type -> new BufferBuilder(type.m_110507_()));
        if (stage != null) {
            STAGE_RENDER_TYPES.computeIfAbsent(stage, unused -> new HashSet()).add(renderType);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLevelStageEnd(RenderLevelStageEvent event) {
        Set<RenderType> stages = STAGE_RENDER_TYPES.get(event.getStage());
        if (stages != null) {
            MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
            stages.forEach(renderType -> {
                if (CUSTOM_BLOCK_LAYERS.contains(renderType)) {
                    Vec3 pos = event.getCamera().m_90583_();
                    ((LevelRendererBlockLayerExtension)event.getLevelRenderer()).veil$drawBlockLayer((RenderType)renderType, event.getPoseStack(), pos.f_82479_, pos.f_82480_, pos.f_82481_, event.getProjectionMatrix());
                }
                bufferSource.m_109912_(renderType);
            });
        }
    }

    public static List<RenderType> getBlockLayers() {
        return BLOCK_LAYERS;
    }

    public static void setBlockLayers(ImmutableList.Builder<RenderType> blockLayers) {
        CUSTOM_BLOCK_LAYERS = new HashSet<RenderType>((Collection<RenderType>)blockLayers.build());
        blockLayers.addAll((Iterable)RenderType.m_110506_());
        BLOCK_LAYERS = blockLayers.build();
    }
}

