/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.particle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.Veil;
import foundry.veil.api.TickTaskScheduler;
import foundry.veil.api.quasar.data.EmitterSettings;
import foundry.veil.api.quasar.data.EmitterShapeSettings;
import foundry.veil.api.quasar.data.ParticleEmitterData;
import foundry.veil.api.quasar.data.ParticleSettings;
import foundry.veil.api.quasar.data.QuasarParticleData;
import foundry.veil.api.quasar.data.module.CodeModule;
import foundry.veil.api.quasar.data.module.ParticleModuleData;
import foundry.veil.api.quasar.emitters.module.update.FaceVelocityModule;
import foundry.veil.api.quasar.particle.ParticleModuleSet;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.api.quasar.particle.QuasarParticle;
import foundry.veil.api.quasar.particle.RenderData;
import foundry.veil.api.quasar.particle.RenderStyle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ParticleEmitter {
    private static final Set<Holder<ParticleModuleData>> REPORTED_MODULES = new HashSet<Holder<ParticleModuleData>>();
    private final ParticleSystemManager particleManager;
    private final ClientLevel level;
    private final ParticleEmitterData emitterData;
    private final List<ParticleModuleData> modules;
    private final RandomSource randomSource;
    private final Vector3d position;
    private final Vector3d offset;
    private final List<QuasarParticle> particles;
    private int maxLifetime;
    private boolean loop;
    private int rate;
    private int count;
    private int maxParticles;
    private List<EmitterShapeSettings> emitterShapeSettings;
    private ParticleSettings particleSettings;
    private boolean forceSpawn;
    private QuasarParticleData particleData;
    @Nullable
    private Entity attachedEntity;
    private CompletableFuture<?> spawnTask;
    private CompletableFuture<?> removeTask;
    private boolean removed;

    ParticleEmitter(ParticleSystemManager particleManager, ClientLevel level, ParticleEmitterData data) {
        this.particleManager = particleManager;
        this.level = level;
        this.emitterData = data;
        this.modules = ParticleEmitter.createModuleSet(data.particleData());
        this.randomSource = RandomSource.m_216327_();
        this.position = new Vector3d();
        this.offset = new Vector3d();
        this.particles = new ArrayList<QuasarParticle>();
        this.maxLifetime = data.maxLifetime();
        this.loop = data.loop();
        this.rate = data.rate();
        this.count = data.count();
        this.maxParticles = data.maxParticles();
        EmitterSettings emitterSettings = data.emitterSettings();
        this.emitterShapeSettings = emitterSettings.emitterShapeSettings();
        this.particleSettings = emitterSettings.particleSettings();
        this.forceSpawn = emitterSettings.forceSpawn();
        this.particleData = data.particleData();
        TickTaskScheduler scheduler = particleManager.getScheduler();
        this.spawnTask = scheduler.scheduleAtFixedRate(this::spawn, 0, data.rate());
        this.reset();
    }

    @ApiStatus.Internal
    public static void clearErrors() {
        REPORTED_MODULES.clear();
    }

    private void spawn() {
        int count = Math.min(this.maxParticles, this.count);
        this.particleManager.reserve(count);
        for (int i = 0; i < count; ++i) {
            Vector3d particlePos = this.emitterShapeSettings.get(i % this.emitterShapeSettings.size()).getPos(this.randomSource, (Vector3dc)this.position);
            Vector3f particleDirection = this.particleSettings.particleDirection(this.randomSource);
            ParticleModuleSet.Builder builder = ParticleModuleSet.builder();
            for (ParticleModuleData module : this.modules) {
                module.addModules(builder);
            }
            if (this.particleData.faceVelocity()) {
                builder.addModule(new FaceVelocityModule());
            }
            QuasarParticle particle = new QuasarParticle(this.level, this.randomSource, this.particleManager.getScheduler(), this.particleData, builder.build(), this.particleSettings, this);
            particle.getPosition().set((Vector3dc)particlePos);
            particle.getVelocity().set((Vector3fc)particleDirection);
            particle.init();
            this.particles.add(particle);
        }
    }

    private static List<ParticleModuleData> createModuleSet(QuasarParticleData data) {
        ArrayList<ParticleModuleData> list = new ArrayList<ParticleModuleData>();
        data.allModules().forEach(module -> {
            if (!module.m_203633_()) {
                if (REPORTED_MODULES.add((Holder<ParticleModuleData>)module)) {
                    String string;
                    if (module instanceof Holder.Reference) {
                        Holder.Reference ref = (Holder.Reference)module;
                        string = ref.m_205785_().m_135782_();
                    } else {
                        string = module.getClass().getName();
                    }
                    Veil.LOGGER.error("Unknown module: {}", (Object)string);
                }
                return;
            }
            list.add((ParticleModuleData)module.m_203334_());
        });
        return list;
    }

    private void expire() {
        if (this.loop) {
            this.reset();
        } else {
            this.remove();
        }
    }

    private void cancelTasks() {
        if (this.spawnTask != null) {
            this.spawnTask.cancel(false);
            this.spawnTask = null;
        }
        if (this.removeTask != null) {
            this.removeTask.cancel(false);
            this.removeTask = null;
        }
    }

    @ApiStatus.Internal
    void tick() {
        this.position.set(0.0);
        if (this.attachedEntity != null) {
            if (this.attachedEntity.m_6084_()) {
                Vec3 pos = this.attachedEntity.m_20182_();
                this.position.set(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            } else {
                this.attachedEntity = null;
                this.remove();
            }
        }
        this.position.add((Vector3dc)this.offset);
        Iterator<QuasarParticle> iterator = this.particles.iterator();
        while (iterator.hasNext()) {
            QuasarParticle particle = iterator.next();
            particle.tick();
            if (!particle.isRemoved()) continue;
            iterator.remove();
            particle.onRemove();
        }
    }

    @ApiStatus.Internal
    public void render(PoseStack poseStack, MultiBufferSource bufferSource, Camera camera, float partialTicks) {
        Vec3 projectedView = camera.m_90583_();
        RenderStyle renderStyle = this.particleData.renderStyle();
        Vector3f renderOffset = new Vector3f();
        RenderType lastRenderType = null;
        VertexConsumer builder = null;
        for (QuasarParticle particle : this.particles) {
            RenderData renderData = particle.getRenderData();
            particle.render(partialTicks);
            renderData.renderTrails(poseStack, bufferSource, projectedView, 0xF000F0);
            Vector3dc renderPosition = renderData.getRenderPosition();
            renderOffset.set((float)(renderPosition.x() - projectedView.m_7096_()), (float)(renderPosition.y() - projectedView.m_7098_()), (float)(renderPosition.z() - projectedView.m_7094_()));
            RenderType renderType = renderData.getRenderType();
            if (!renderType.equals(lastRenderType)) {
                lastRenderType = renderType;
                builder = bufferSource.m_6299_(renderType);
                TextureAtlasSprite sprite = renderData.getAtlasSprite();
                if (sprite != null) {
                    builder = sprite.m_118381_(builder);
                }
            }
            renderStyle.render(poseStack, particle, renderData, (Vector3fc)renderOffset, builder, 1.0, partialTicks);
        }
    }

    @ApiStatus.Internal
    void onRemoved() {
        this.cancelTasks();
        for (QuasarParticle particle : this.particles) {
            particle.onRemove();
        }
        this.particles.clear();
    }

    public void addCodeModule(CodeModule module) {
        this.modules.add(module);
    }

    public int trim(int count) {
        if (this.forceSpawn) {
            return 0;
        }
        int removeCount = Math.min(count, this.particles.size());
        this.particles.subList(0, removeCount).clear();
        return removeCount;
    }

    public void remove() {
        this.removed = true;
        this.cancelTasks();
    }

    public void reset() {
        this.removed = false;
        if (this.removeTask != null) {
            this.removeTask.cancel(false);
        }
        this.removeTask = this.particleManager.getScheduler().schedule(this::expire, this.maxLifetime);
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return this.emitterData.getRegistryId();
    }

    public boolean isRemoved() {
        return this.removed && this.particles.isEmpty();
    }

    public Vector3d getPosition() {
        return this.position;
    }

    public ParticleEmitterData getData() {
        return this.emitterData;
    }

    public int getParticleCount() {
        return this.particles.size();
    }

    public int getMaxLifetime() {
        return this.maxLifetime;
    }

    public boolean isLoop() {
        return this.loop;
    }

    public int getRate() {
        return this.rate;
    }

    public int getCount() {
        return this.count;
    }

    public int getMaxParticles() {
        return this.maxParticles;
    }

    public List<EmitterShapeSettings> getEmitterShapeSettings() {
        return this.emitterShapeSettings;
    }

    public ParticleSettings getParticleSettings() {
        return this.particleSettings;
    }

    public boolean isForceSpawn() {
        return this.forceSpawn;
    }

    public QuasarParticleData getParticleData() {
        return this.particleData;
    }

    @Nullable
    public Entity getAttachedEntity() {
        return this.attachedEntity;
    }

    @Deprecated
    public void setPosition(Vec3 position) {
        this.setPosition(position.f_82479_, position.f_82480_, position.f_82481_);
    }

    public void setPosition(Vector3dc position) {
        this.setPosition(position.x(), position.y(), position.z());
    }

    public void setPosition(double x, double y, double z) {
        this.offset.set(x, y, z);
        if (this.attachedEntity != null) {
            this.position.set(this.attachedEntity.m_20185_(), this.attachedEntity.m_20186_(), this.attachedEntity.m_20189_()).add((Vector3dc)this.offset);
        } else {
            this.position.set((Vector3dc)this.offset);
        }
    }

    public void setMaxLifetime(int maxLifetime) {
        this.maxLifetime = maxLifetime;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public void setRate(int rate) {
        this.rate = rate;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setMaxParticles(int maxParticles) {
        this.maxParticles = maxParticles;
    }

    public void setEmitterShapeSettings(List<EmitterShapeSettings> emitterShapeSettings) {
        this.emitterShapeSettings = emitterShapeSettings;
    }

    public void setParticleSettings(ParticleSettings particleSettings) {
        this.particleSettings = particleSettings;
    }

    public void setForceSpawn(boolean forceSpawn) {
        this.forceSpawn = forceSpawn;
    }

    public void setParticleData(QuasarParticleData particleData) {
        this.particleData = particleData;
    }

    public void setAttachedEntity(@Nullable Entity entity) {
        this.attachedEntity = entity;
        if (entity != null) {
            this.position.set(entity.m_20185_(), entity.m_20186_(), entity.m_20189_()).add((Vector3dc)this.offset);
        } else {
            this.position.set((Vector3dc)this.offset);
        }
    }
}

