/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.Veil;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.forge.ForgeRenderTypeStageHandler;
import foundry.veil.forge.event.ForgeVeilRegisterBlockLayerEvent;
import foundry.veil.forge.event.ForgeVeilRegisterFixedBuffersEvent;
import foundry.veil.forge.event.ForgeVeilRendererEvent;
import foundry.veil.impl.VeilBuiltinPacks;
import foundry.veil.impl.VeilReloadListeners;
import foundry.veil.impl.client.render.VeilUITooltipRenderer;
import foundry.veil.impl.client.render.shader.VeilVanillaShaders;
import foundry.veil.mixin.accessor.RenderStateShardAccessor;
import java.nio.file.Path;
import java.util.function.Consumer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraftforge.client.event.RegisterClientReloadListenersEvent;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.client.event.RegisterShadersEvent;
import net.minecraftforge.client.gui.overlay.VanillaGuiOverlay;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoader;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class VeilForgeClient {
    public static void init() {
        VeilClient.init();
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(VeilForgeClient::registerKeys);
        modEventBus.addListener(VeilForgeClient::registerGuiOverlays);
        modEventBus.addListener(VeilForgeClient::registerListeners);
        modEventBus.addListener(VeilForgeClient::registerShaders);
        modEventBus.addListener(VeilForgeClient::addPackFinders);
        ImmutableList.Builder blockLayers = ImmutableList.builder();
        ModLoader.get().postEvent((Event)new ForgeVeilRegisterBlockLayerEvent(renderType -> {
            if (Veil.platform().isDevelopmentEnvironment() && renderType.m_110507_() > 131072) {
                Veil.LOGGER.warn("Block render layer '{}' uses a large buffer size: {}. If this is intended you can ignore this message", (Object)((RenderStateShardAccessor)renderType).getName(), (Object)renderType.m_110507_());
            }
            blockLayers.add((Object)renderType);
        }));
        ForgeRenderTypeStageHandler.setBlockLayers((ImmutableList.Builder<RenderType>)blockLayers);
    }

    private static void registerListeners(RegisterClientReloadListenersEvent event) {
        VeilClient.initRenderer();
        VeilReloadListeners.registerListeners((PackType type, String id, PreparableReloadListener listener) -> event.registerReloadListener(listener));
        ModLoader loader = ModLoader.get();
        loader.postEvent((Event)new ForgeVeilRendererEvent(VeilRenderSystem.renderer()));
        loader.postEvent((Event)new ForgeVeilRegisterFixedBuffersEvent(ForgeRenderTypeStageHandler::register));
    }

    private static void registerKeys(RegisterKeyMappingsEvent event) {
        event.register(VeilClient.EDITOR_KEY);
    }

    private static void registerGuiOverlays(RegisterGuiOverlaysEvent event) {
        event.registerAbove(VanillaGuiOverlay.HOTBAR.id(), "uitooltip", VeilUITooltipRenderer::renderOverlay);
    }

    private static void registerShaders(RegisterShadersEvent event) {
        try {
            VeilVanillaShaders.registerShaders((ResourceLocation id, VertexFormat vertexFormat, Consumer<ShaderInstance> loadCallback) -> event.registerShader(new ShaderInstance(event.getResourceProvider(), id, vertexFormat), loadCallback));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            VeilBuiltinPacks.registerPacks((id, defaultEnabled) -> VeilForgeClient.registerBuiltinPack(event, id));
        }
    }

    private static void registerBuiltinPack(AddPackFindersEvent event, ResourceLocation id) {
        Path resourcePath = ModList.get().getModFileById("veil").getFile().findResource(new String[]{"resourcepacks/" + id.m_135815_()});
        Pack pack = Pack.m_245429_((String)id.toString(), (Component)Component.m_237113_((String)(id.m_135827_() + "/" + id.m_135815_())), (boolean)false, packId -> new PathPackResources(packId, true, resourcePath), (PackType)PackType.CLIENT_RESOURCES, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_10528_);
        if (pack == null) {
            Veil.LOGGER.error("Failed to find builtin pack: {}", (Object)id);
            return;
        }
        event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
    }
}

