/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.util.CodecUtil;
import net.minecraft.core.Holder;
import net.minecraft.resources.RegistryFileCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public record ParticleSettings(float particleSpeed, float particleSize, float particleSizeVariation, int particleLifetime, float particleLifetimeVariation, Vector3fc initialDirection, boolean randomInitialDirection, boolean randomInitialRotation, boolean randomSpeed, boolean randomSize, boolean randomLifetime) {
    public static final Codec<ParticleSettings> DIRECT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.FLOAT.fieldOf("particle_speed").forGetter(ParticleSettings::particleSpeed), (App)Codec.FLOAT.fieldOf("base_particle_size").forGetter(ParticleSettings::particleSize), (App)Codec.FLOAT.fieldOf("particle_size_variation").forGetter(ParticleSettings::particleSizeVariation), (App)Codec.INT.fieldOf("particle_lifetime").forGetter(ParticleSettings::particleLifetime), (App)Codec.FLOAT.fieldOf("particle_lifetime_variation").forGetter(ParticleSettings::particleLifetimeVariation), (App)CodecUtil.VECTOR3F_CODEC.fieldOf("initial_direction").forGetter(ParticleSettings::initialDirection), (App)Codec.BOOL.fieldOf("random_initial_direction").forGetter(ParticleSettings::randomInitialDirection), (App)Codec.BOOL.fieldOf("random_initial_rotation").forGetter(ParticleSettings::randomInitialRotation), (App)Codec.BOOL.fieldOf("random_speed").forGetter(ParticleSettings::randomSpeed), (App)Codec.BOOL.fieldOf("random_size").forGetter(ParticleSettings::randomSize), (App)Codec.BOOL.fieldOf("random_lifetime").forGetter(ParticleSettings::randomLifetime)).apply((Applicative)instance, ParticleSettings::new));
    public static final Codec<Holder<ParticleSettings>> CODEC = RegistryFileCodec.m_135589_(QuasarParticles.PARTICLE_SETTINGS, DIRECT_CODEC);

    public float particleSpeed(RandomSource random) {
        return this.randomSpeed ? this.particleSpeed + (random.m_188501_() * 0.5f - 0.5f) * this.particleSpeed : this.particleSpeed;
    }

    public float particleSize(RandomSource random) {
        return this.randomSize ? this.particleSize + random.m_188501_() * this.particleSizeVariation : this.particleSize;
    }

    public int particleLifetime(RandomSource random) {
        return this.randomLifetime ? this.particleLifetime + (int)(random.m_188501_() * this.particleLifetimeVariation) : this.particleLifetime;
    }

    public Vector3fc initialDirection(RandomSource random) {
        return this.randomInitialDirection ? this.initialDirection.mul(random.m_188501_() * 2.0f - 1.0f, random.m_188501_() * 2.0f - 1.0f, random.m_188501_() * 2.0f - 1.0f, new Vector3f()) : this.initialDirection;
    }

    public Vector3f particleDirection(RandomSource random) {
        return this.initialDirection(random).mul(this.particleSpeed(), new Vector3f());
    }

    @Nullable
    public ResourceLocation getRegistryId() {
        return QuasarParticles.registryAccess().m_6632_(QuasarParticles.PARTICLE_SETTINGS).map(registry -> registry.m_7981_((Object)this)).orElse(null);
    }
}

