/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import foundry.veil.VeilClient;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.quasar.data.QuasarParticles;
import foundry.veil.api.quasar.particle.ParticleEmitter;
import foundry.veil.api.quasar.particle.ParticleSystemManager;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.arguments.coordinates.WorldCoordinates;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterClientCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.ApiStatus;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE, modid="veil", value={Dist.CLIENT})
@ApiStatus.Internal
public class VeilForgeClientEvents {
    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            VeilClient.tickClient(Minecraft.m_91087_().m_91296_());
        }
    }

    @SubscribeEvent
    public static void tick(TickEvent.LevelTickEvent event) {
        if (event.phase == TickEvent.Phase.START && event.side.isClient()) {
            VeilRenderSystem.renderer().getParticleManager().tick();
        }
    }

    @SubscribeEvent
    public static void keyPressed(InputEvent.Key event) {
        if (event.getAction() == 1 && VeilClient.EDITOR_KEY.m_90832_(event.getKey(), event.getScanCode())) {
            VeilImGuiImpl.get().toggle();
        }
    }

    @SubscribeEvent
    public static void registerClientCommands(RegisterClientCommandsEvent event) {
        LiteralArgumentBuilder builder = Commands.m_82127_((String)"quasar");
        builder.then(Commands.m_82129_((String)"emitter", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(QuasarParticles.emitterSuggestionProvider()).then(Commands.m_82129_((String)"position", (ArgumentType)Vec3Argument.m_120841_()).executes(ctx -> {
            ResourceLocation id = ResourceLocationArgument.m_107011_((CommandContext)ctx, (String)"emitter");
            CommandSourceStack source = (CommandSourceStack)ctx.getSource();
            ParticleSystemManager particleManager = VeilRenderSystem.renderer().getParticleManager();
            ParticleEmitter instance = particleManager.createEmitter(id);
            if (instance == null) {
                source.m_81352_((Component)Component.m_237113_((String)("Unknown emitter: " + id)));
                return 0;
            }
            WorldCoordinates coordinates = (WorldCoordinates)ctx.getArgument("position", WorldCoordinates.class);
            Vec3 pos = coordinates.m_6955_(source);
            instance.setPosition(pos.f_82479_, pos.f_82480_, pos.f_82481_);
            particleManager.addParticleSystem(instance);
            source.m_288197_(() -> Component.m_237113_((String)("Spawned " + id)), true);
            return 1;
        })));
        event.getDispatcher().register(builder);
    }

    @SubscribeEvent
    public static void mousePressed(InputEvent.MouseButton.Pre event) {
        if (event.getAction() == 1 && VeilClient.EDITOR_KEY.m_90830_(event.getButton())) {
            VeilImGuiImpl.get().toggle();
        }
    }

    @SubscribeEvent
    public static void leaveGame(ClientPlayerNetworkEvent.LoggingOut event) {
        VeilRenderSystem.renderer().getDeferredRenderer().reset();
    }
}

