/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import foundry.veil.mixin.accessor.RegistryDataAccessor;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public class VeilDynamicRegistry {
    private static final ThreadLocal<Boolean> LOADING = ThreadLocal.withInitial(() -> false);

    public static Data loadRegistries(ResourceManager resourceManager, Collection<RegistryDataLoader.RegistryData<?>> registries) {
        HashMap errors = new HashMap();
        LOADING.set(true);
        List<Pair> loaders = registries.stream().map(data -> ((RegistryDataAccessor)data).invokeCreate(Lifecycle.stable(), errors)).toList();
        RegistryOps.RegistryInfoLookup lookup = RegistryDataLoader.m_255261_((RegistryAccess)RegistryAccess.f_243945_, loaders);
        loaders.forEach(pair -> ((RegistryDataLoader.Loader)pair.getSecond()).m_245441_(resourceManager, lookup));
        loaders.forEach(pair -> {
            Registry registry = (Registry)pair.getFirst();
            try {
                registry.m_203521_();
            }
            catch (Exception e) {
                errors.put(registry.m_123023_(), e);
            }
        });
        LOADING.set(false);
        RegistryAccess.Frozen registryAccess = new RegistryAccess.ImmutableRegistryAccess(loaders.stream().map(Pair::getFirst).toList()).m_203557_();
        return new Data((RegistryAccess)registryAccess, errors);
    }

    @Nullable
    public static String printErrors(Map<ResourceKey<?>, Exception> errors) {
        if (errors.isEmpty()) {
            return null;
        }
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        Map<ResourceLocation, Map<ResourceLocation, Exception>> sortedErrors = errors.entrySet().stream().collect(Collectors.groupingBy(entry -> ((ResourceKey)entry.getKey()).m_211136_(), Collectors.toMap(entry -> ((ResourceKey)entry.getKey()).m_135782_(), Map.Entry::getValue)));
        sortedErrors.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(registryError -> {
            printWriter.printf("%n> %d Errors in registry %s:", ((Map)registryError.getValue()).size(), registryError.getKey());
            ((Map)registryError.getValue()).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(elementError -> {
                Throwable error = (Throwable)elementError.getValue();
                while (error.getCause() != null) {
                    error = error.getCause();
                }
                printWriter.printf("%n>> Error in element %s: %s", elementError.getKey(), error.getMessage());
            });
        });
        printWriter.flush();
        return stringWriter.toString();
    }

    @ApiStatus.Internal
    public static boolean isLoading() {
        return LOADING.get();
    }

    public record Data(RegistryAccess registryAccess, Map<ResourceKey<?>, Exception> errors) {
    }
}

