/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render.deferred.light;

import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.deferred.light.InstancedLight;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.PositionedLight;
import imgui.ImGui;
import imgui.type.ImDouble;
import imgui.type.ImFloat;
import java.nio.ByteBuffer;
import net.minecraft.client.Camera;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4d;
import org.joml.Matrix4dc;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class AreaLight
extends Light
implements InstancedLight,
PositionedLight<AreaLight>,
EditorAttributeProvider {
    private static final float MAX_ANGLE_SIZE = 10430.06f;
    protected final Vector3d position;
    protected final Quaternionf orientation;
    private final Matrix4d matrix = new Matrix4d();
    protected final Vector2f size;
    protected float angle;
    protected float distance = 1.0f;

    public AreaLight() {
        this.position = new Vector3d();
        this.orientation = new Quaternionf();
        this.size = new Vector2f(1.0f, 1.0f);
        this.angle = (float)Math.toRadians(45.0);
    }

    @Override
    public void store(ByteBuffer buffer) {
        this.matrix.getFloats(buffer.position(), buffer);
        buffer.position(buffer.position() + 64);
        buffer.putFloat(this.color.x() * this.brightness);
        buffer.putFloat(this.color.y() * this.brightness);
        buffer.putFloat(this.color.z() * this.brightness);
        this.size.get(buffer.position(), buffer);
        buffer.position(buffer.position() + 8);
        buffer.putShort((short)Mth.m_14045_((int)((int)(this.angle * 10430.06f)), (int)0, (int)65535));
        buffer.putFloat(this.distance);
    }

    @Override
    public LightTypeRegistry.LightType<?> getType() {
        return LightTypeRegistry.AREA.get();
    }

    @Override
    public Vector3d getPosition() {
        return this.position;
    }

    public Quaternionf getOrientation() {
        return this.orientation;
    }

    public Vector2f getSize() {
        return this.size;
    }

    public float getAngle() {
        return this.angle;
    }

    public float getDistance() {
        return this.distance;
    }

    @Override
    public AreaLight setColor(float red, float green, float blue) {
        return (AreaLight)super.setColor(red, green, blue);
    }

    @Override
    public AreaLight setColor(Vector3fc color) {
        return (AreaLight)super.setColor(color);
    }

    @Override
    public AreaLight setBrightness(float brightness) {
        return (AreaLight)super.setBrightness(brightness);
    }

    @Override
    public AreaLight setPosition(double x, double y, double z) {
        this.position.set(x, y, z);
        this.updateMatrix();
        return this;
    }

    public AreaLight setOrientation(Quaternionfc orientation) {
        this.orientation.set(orientation).normalize();
        this.updateMatrix();
        return this;
    }

    public AreaLight setSize(double x, double y) {
        this.size.set(x, y);
        this.markDirty();
        return this;
    }

    public AreaLight setAngle(float angle) {
        this.angle = angle;
        this.markDirty();
        return this;
    }

    public AreaLight setDistance(float distance) {
        this.distance = distance;
        this.markDirty();
        return this;
    }

    @Override
    public Light setTo(Camera camera) {
        Vec3 pos = camera.m_90583_();
        return this.setPosition(pos.f_82479_, pos.f_82480_, pos.f_82481_).setOrientation((Quaternionfc)new Quaternionf().lookAlong((Vector3fc)camera.m_253058_().mul(-1.0f), (Vector3fc)camera.m_253028_()));
    }

    protected void updateMatrix() {
        Vector3d position = this.getPosition();
        Quaternionf orientation = this.getOrientation();
        this.matrix.rotation((Quaternionfc)orientation).translate((Vector3dc)position);
        this.markDirty();
    }

    @Override
    public AreaLight clone() {
        AreaLight light = new AreaLight();
        light.matrix.set((Matrix4dc)this.matrix);
        light.size.set((Vector2fc)this.size);
        light.angle = this.angle;
        light.distance = this.distance;
        light.markDirty();
        return light;
    }

    @Override
    public void renderImGuiAttributes() {
        Vector3f orientationAngles = this.orientation.getEulerAnglesXYZ(new Vector3f());
        float[] editSize = new float[]{this.size.x(), this.size.y()};
        ImDouble editX = new ImDouble(this.position.x());
        ImDouble editY = new ImDouble(this.position.y());
        ImDouble editZ = new ImDouble(this.position.z());
        float[] editXRot = new float[]{orientationAngles.x()};
        float[] editYRot = new float[]{orientationAngles.y()};
        float[] editZRot = new float[]{orientationAngles.z()};
        float[] editAngle = new float[]{this.angle};
        ImFloat editDistance = new ImFloat(this.distance);
        if (ImGui.dragFloat2((String)"size", (float[])editSize, (float)0.02f, (float)1.0E-4f)) {
            this.setSize(editSize[0], editSize[1]);
        }
        float totalWidth = ImGui.calcItemWidth();
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.dragScalar((String)"##x", (int)9, (ImDouble)editX, (float)0.02f)) {
            this.setPosition(editX.get(), this.position.y(), this.position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##y", (int)9, (ImDouble)editY, (float)0.02f)) {
            this.setPosition(this.position.x(), editY.get(), this.position.z());
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.dragScalar((String)"##z", (int)9, (ImDouble)editZ, (float)0.02f)) {
            this.setPosition(this.position.x(), this.position.y(), editZ.get());
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"position");
        ImGui.pushItemWidth((float)(totalWidth / 3.0f - ImGui.getStyle().getItemInnerSpacingX() * 0.58f));
        if (ImGui.sliderAngle((String)"##xrot", (float[])editXRot)) {
            this.setOrientation((Quaternionfc)new Quaternionf().rotationXYZ(editXRot[0], orientationAngles.y(), orientationAngles.z()));
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.sliderAngle((String)"##yrot", (float[])editYRot)) {
            this.setOrientation((Quaternionfc)new Quaternionf().rotationXYZ(orientationAngles.x(), editYRot[0], orientationAngles.z()));
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.sliderAngle((String)"##zrot", (float[])editZRot)) {
            this.setOrientation((Quaternionfc)new Quaternionf().rotationXYZ(orientationAngles.x(), orientationAngles.y(), editZRot[0]));
        }
        ImGui.popItemWidth();
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"orientation");
        if (ImGui.sliderAngle((String)"##angle", (float[])editAngle, (float)0.0f, (float)180.0f, (String)"%.1f")) {
            this.setAngle(editAngle[0]);
        }
        ImGui.sameLine((float)0.0f, (float)ImGui.getStyle().getItemInnerSpacingX());
        ImGui.text((String)"angle");
        if (ImGui.dragScalar((String)"distance", (int)8, (ImFloat)editDistance, (float)0.02f, (float)0.0f)) {
            this.setDistance(editDistance.get());
        }
    }
}

