/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.graveyard.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import foundry.veil.api.client.graveyard.AnimationProperties;
import foundry.veil.api.client.graveyard.render.InterpolatedEntityRenderLayer;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeleton;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedSkeletonParent;
import foundry.veil.api.client.graveyard.skeleton.SkeletonFactory;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public abstract class InterpolatedEntityRenderer<T extends LivingEntity, S extends InterpolatedSkeleton>
extends EntityRenderer<T> {
    protected final SkeletonFactory<S> modelFactory;
    private final List<InterpolatedEntityRenderLayer<T, S>> layers = new ArrayList<InterpolatedEntityRenderLayer<T, S>>();

    protected InterpolatedEntityRenderer(EntityRendererProvider.Context pContext, SkeletonFactory<S> modelFactory, float shadowRadius) {
        super(pContext);
        this.modelFactory = modelFactory;
        this.f_114477_ = shadowRadius;
    }

    public void setupModelFactory(T parent) {
    }

    public final void createSkeleton(T parent) {
        this.setupModelFactory(parent);
        ((InterpolatedSkeletonParent)parent).setSkeleton((InterpolatedSkeleton)this.modelFactory.create());
    }

    public final boolean addLayer(InterpolatedEntityRenderLayer<T, S> layer) {
        return this.layers.add(layer);
    }

    public void render(T entity, float yaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_85841_(0.0625f, 0.0625f, 0.0625f);
        this.setupRotations(entity, poseStack, (float)((LivingEntity)entity).f_19797_ + partialTicks, partialTicks);
        Minecraft minecraft = Minecraft.m_91087_();
        boolean invisible = entity.m_20145_();
        boolean isSpectatorTransparent = !invisible && !entity.m_20177_((Player)minecraft.f_91074_);
        boolean glowing = minecraft.m_91314_(entity);
        RenderType rendertype = this.getRenderType(entity, invisible, isSpectatorTransparent, glowing);
        if (rendertype != null) {
            this.renderModel(entity, partialTicks, poseStack, buffer, packedLight);
        }
        InterpolatedSkeleton skeleton = ((InterpolatedSkeletonParent)entity).getSkeleton();
        if (!entity.m_5833_()) {
            for (InterpolatedEntityRenderLayer<T, S> layer : this.layers) {
                if (skeleton == null) continue;
                layer.render(poseStack, buffer, packedLight, entity, skeleton, partialTicks);
            }
        }
        if (skeleton != null) {
            skeleton.renderDebug((InterpolatedSkeletonParent)entity, poseStack, buffer, partialTicks);
        }
        poseStack.m_85849_();
        super.m_7392_(entity, yaw, partialTicks, poseStack, buffer, packedLight);
    }

    public void renderModel(T pEntity, float pPartialTicks, PoseStack poseStack, MultiBufferSource pBuffer, int pPackedLight) {
        InterpolatedSkeleton skeleton = ((InterpolatedSkeletonParent)pEntity).getSkeleton();
        if (skeleton == null) {
            return;
        }
        VertexConsumer vertexconsumer = pBuffer.m_6299_(this.getRenderType(pEntity));
        int packedOverlay = LivingEntityRenderer.m_115338_(pEntity, (float)0.0f);
        skeleton.render(poseStack, vertexconsumer, pPackedLight, packedOverlay, pPartialTicks, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    public abstract RenderType getRenderType(T var1);

    protected RenderType getRenderType(T pLivingEntity, boolean pBodyVisible, boolean pTranslucent, boolean pGlowing) {
        ResourceLocation resourcelocation = this.m_5478_((Entity)pLivingEntity);
        if (pTranslucent) {
            return RenderType.m_110467_((ResourceLocation)resourcelocation);
        }
        if (pBodyVisible) {
            return this.getRenderType(pLivingEntity);
        }
        return pGlowing ? RenderType.m_110491_((ResourceLocation)resourcelocation) : null;
    }

    protected void setupRotations(T pEntityLiving, PoseStack pMatrixStack, float pAgeInTicks, float pPartialTicks) {
        if (((LivingEntity)pEntityLiving).f_20919_ > 0) {
            float deathTime = ((float)((LivingEntity)pEntityLiving).f_20919_ + pPartialTicks - 1.0f) / 20.0f * 1.6f;
            if ((deathTime = Mth.m_14116_((float)deathTime)) > 1.0f) {
                deathTime = 1.0f;
            }
            pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(deathTime * this.getFlipDegrees(pEntityLiving)));
        } else if (pEntityLiving.m_21209_()) {
            pMatrixStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f - pEntityLiving.m_146909_()));
            pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(((float)((LivingEntity)pEntityLiving).f_19797_ + pPartialTicks) * -75.0f));
        } else if (LivingEntityRenderer.m_194453_(pEntityLiving)) {
            pMatrixStack.m_85837_(0.0, (double)(pEntityLiving.m_20206_() + 0.1f), 0.0);
            pMatrixStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        }
        if (pEntityLiving.m_146890_()) {
            pMatrixStack.m_252781_(Axis.f_252436_.m_252977_(Mth.m_14089_((float)((float)((LivingEntity)pEntityLiving).f_19797_ * 3.25f)) * (float)Math.PI * 0.4f));
        }
    }

    protected float getFlipDegrees(T entity) {
        return 90.0f;
    }

    public static void tick(List<InterpolatedSkeletonParent> entitiesToRender) {
        for (InterpolatedSkeletonParent interpolatedSkeletonParent : entitiesToRender) {
            AnimationProperties properties = new AnimationProperties();
            interpolatedSkeletonParent.getSkeleton().addAnimationProperties(properties, interpolatedSkeletonParent);
            interpolatedSkeletonParent.getSkeleton().tick(properties);
        }
    }
}

