/*
 * Decompiled with CFR 0.152.
 */
package gg.moonflower.molangcompiler.api;

import gg.moonflower.molangcompiler.api.MolangEnvironment;
import gg.moonflower.molangcompiler.api.bridge.MolangJavaFunction;
import gg.moonflower.molangcompiler.api.bridge.MolangVariable;
import gg.moonflower.molangcompiler.api.exception.MolangRuntimeException;
import gg.moonflower.molangcompiler.core.node.MolangCompoundNode;
import gg.moonflower.molangcompiler.core.node.MolangConstantNode;
import gg.moonflower.molangcompiler.core.node.MolangDynamicNode;
import gg.moonflower.molangcompiler.core.node.MolangFunctionNode;
import gg.moonflower.molangcompiler.core.node.MolangLazyNode;
import gg.moonflower.molangcompiler.core.node.MolangVariableNode;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public interface MolangExpression {
    public static final MolangExpression ZERO = MolangExpression.of(0.0f);

    @ApiStatus.OverrideOnly
    public float get(MolangEnvironment var1) throws MolangRuntimeException;

    default public float getConstant() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Expression is not constant");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="4.0.0")
    default public float resolve(MolangEnvironment environment) throws MolangRuntimeException {
        return environment.resolve(this);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="4.0.0")
    default public float safeResolve(MolangEnvironment environment) {
        return environment.safeResolve(this);
    }

    default public boolean isConstant() {
        return false;
    }

    default public MolangExpression getCopy() {
        return this;
    }

    public static MolangExpression of(float value) {
        return new MolangConstantNode(value);
    }

    public static MolangExpression of(boolean value) {
        return new MolangConstantNode(value ? 1.0f : 0.0f);
    }

    public static MolangExpression of(Supplier<Float> value) {
        return new MolangDynamicNode(value);
    }

    public static MolangExpression lazy(Supplier<Float> value) {
        return new MolangLazyNode(value);
    }

    public static MolangExpression function(int params, MolangJavaFunction consumer) {
        return new MolangFunctionNode(params, consumer);
    }

    public static MolangExpression function(MolangJavaFunction consumer) {
        return new MolangFunctionNode(-1, consumer);
    }

    public static MolangExpression of(BooleanSupplier value) {
        return new MolangDynamicNode(() -> Float.valueOf(value.getAsBoolean() ? 1.0f : 0.0f));
    }

    public static MolangExpression lazy(BooleanSupplier value) {
        return new MolangLazyNode(() -> Float.valueOf(value.getAsBoolean() ? 1.0f : 0.0f));
    }

    public static MolangExpression of(MolangVariable value) {
        return new MolangVariableNode(value);
    }

    public static MolangExpression of(MolangExpression ... expressions) {
        if (expressions.length == 0) {
            return ZERO;
        }
        if (expressions.length == 1) {
            return expressions[0];
        }
        return new MolangCompoundNode(expressions);
    }
}

