/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.editor;

import foundry.veil.Veil;
import foundry.veil.api.client.editor.Editor;
import foundry.veil.api.client.editor.EditorFontManager;
import foundry.veil.api.client.registry.VeilResourceEditorRegistry;
import foundry.veil.api.resource.editor.ResourceFileEditor;
import foundry.veil.api.util.CompositeReloadListener;
import imgui.ImFont;
import imgui.ImGui;
import imgui.type.ImBoolean;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ReloadableResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public class EditorManager
implements PreparableReloadListener {
    public static final ResourceLocation DEFAULT_FONT = Veil.veilPath("jetbrains_mono");
    private final Map<Editor, ImBoolean> editors = new TreeMap<Editor, ImBoolean>(Comparator.comparing(editor -> editor.getClass().getSimpleName()));
    private final EditorFontManager fonts = new EditorFontManager();
    private boolean enabled = false;

    @ApiStatus.Internal
    public EditorManager(ReloadableResourceManager resourceManager) {
        resourceManager.m_7217_((PreparableReloadListener)this);
    }

    public ImFont getFont(ResourceLocation name, boolean bold, boolean italic) {
        return this.fonts.getFont(name, bold, italic);
    }

    public ImFont getFont(boolean bold, boolean italic) {
        return this.getFont(DEFAULT_FONT, bold, italic);
    }

    @ApiStatus.Internal
    public void render() {
        if (!this.enabled) {
            return;
        }
        if (ImGui.beginMainMenuBar()) {
            Editor editor;
            ImFont font = ImGui.getFont();
            float dingleWidth = font.calcTextSizeAX(ImGui.getFontSize(), Float.MAX_VALUE, 0.0f, " Veil ") + 4.0f;
            float dingleHeight = ImGui.getTextLineHeightWithSpacing() + 2.0f;
            ImGui.getWindowDrawList().addRectFilled(0.0f, 0.0f, dingleWidth, dingleHeight, ImGui.getColorU32(8));
            ImGui.text("Veil ");
            for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                editor = entry.getKey();
                Component group = editor.getGroup();
                if (group == null) {
                    if (Veil.platform().isDevelopmentEnvironment()) {
                        Veil.LOGGER.error("Editor '{}' should return Editor#DEFAULT_GROUP instead of null", editor.getClass());
                    }
                    group = Editor.DEFAULT_GROUP;
                }
                if (!ImGui.beginMenu(group.getString())) continue;
                ImBoolean enabled = entry.getValue();
                ImGui.beginDisabled(!editor.isEnabled());
                if (ImGui.menuItem(editor.getDisplayName().getString(), null, enabled.get())) {
                    if (!enabled.get()) {
                        this.show(editor);
                    } else {
                        this.hide(editor);
                    }
                }
                ImGui.endDisabled();
                ImGui.endMenu();
            }
            for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
                editor = entry.getKey();
                if (!entry.getValue().get() || !editor.isMenuBarEnabled()) continue;
                ImGui.separator();
                ImGui.textColored(-5592406, editor.getDisplayName().getString());
                editor.renderMenuBar();
            }
            ImGui.endMainMenuBar();
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            Editor editor = entry.getKey();
            ImBoolean enabled = entry.getValue();
            if (!editor.isEnabled()) {
                enabled.set(false);
            }
            if (!enabled.get()) continue;
            editor.render();
        }
        for (ResourceFileEditor editor : VeilResourceEditorRegistry.REGISTRY) {
            editor.render();
        }
    }

    @ApiStatus.Internal
    public void renderLast() {
        if (!this.enabled) {
            return;
        }
        for (Map.Entry<Editor, ImBoolean> entry : this.editors.entrySet()) {
            Editor editor = entry.getKey();
            ImBoolean enabled = entry.getValue();
            if (!enabled.get()) continue;
            editor.renderLast();
        }
    }

    public void show(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && !enabled.get()) {
            editor.onShow();
            enabled.set(true);
        }
    }

    public void hide(Editor editor) {
        ImBoolean enabled = this.editors.get(editor);
        if (enabled != null && enabled.get()) {
            editor.onHide();
            enabled.set(false);
        }
    }

    public boolean isVisible(Editor editor) {
        ImBoolean visible = this.editors.get(editor);
        return visible != null && visible.get();
    }

    public synchronized void add(Editor editor) {
        this.editors.computeIfAbsent(editor, unused -> new ImBoolean());
    }

    public synchronized void remove(Editor editor) {
        this.hide(editor);
        this.editors.remove(editor);
    }

    public void toggle() {
        this.enabled = !this.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @NotNull
    public CompletableFuture<Void> m_5540_(@NotNull PreparableReloadListener.PreparationBarrier preparationBarrier, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller prepareProfiler, @NotNull ProfilerFiller applyProfiler, @NotNull Executor backgroundExecutor, @NotNull Executor gameExecutor) {
        PreparableReloadListener listener;
        ArrayList<PreparableReloadListener> listeners = new ArrayList<PreparableReloadListener>(this.editors.size());
        listeners.add(this.fonts);
        for (Editor editor : this.editors.keySet()) {
            if (!(editor instanceof PreparableReloadListener)) continue;
            listener = (PreparableReloadListener)editor;
            listeners.add(listener);
        }
        for (ResourceFileEditor resourceFileEditor : VeilResourceEditorRegistry.REGISTRY) {
            if (!(resourceFileEditor instanceof PreparableReloadListener)) continue;
            listener = (PreparableReloadListener)resourceFileEditor;
            listeners.add(listener);
        }
        PreparableReloadListener listener2 = CompositeReloadListener.of((PreparableReloadListener[])listeners.toArray(PreparableReloadListener[]::new));
        return listener2.m_5540_(preparationBarrier, resourceManager, prepareProfiler, applyProfiler, backgroundExecutor, gameExecutor);
    }
}

