/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.glsl.node.function;

import foundry.veil.impl.glsl.grammar.GlslFunctionHeader;
import foundry.veil.impl.glsl.node.GlslNode;
import foundry.veil.impl.glsl.node.branch.GlslReturnNode;
import foundry.veil.impl.glsl.node.expression.GlslAssignmentNode;
import foundry.veil.impl.glsl.visitor.GlslFunctionVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class GlslFunctionNode
implements GlslNode {
    private GlslFunctionHeader header;
    private List<GlslNode> body;

    public GlslFunctionNode(GlslFunctionHeader header, @Nullable GlslNode body) {
        this.header = header;
        this.body = body != null ? body.toList() : null;
    }

    public void visit(GlslFunctionVisitor visitor) {
        for (GlslNode node : this.body) {
            if (node instanceof GlslReturnNode) {
                GlslReturnNode returnNode = (GlslReturnNode)node;
                visitor.visitReturn(returnNode);
                return;
            }
            if (node instanceof GlslAssignmentNode) {
                GlslAssignmentNode assignmentNode = (GlslAssignmentNode)node;
                visitor.visitAssignment(assignmentNode);
                return;
            }
            System.out.println(node);
        }
        visitor.visitFunctionEnd();
    }

    public GlslFunctionHeader getHeader() {
        return this.header;
    }

    @Nullable
    public List<GlslNode> getBody() {
        return this.body;
    }

    public void setHeader(GlslFunctionHeader header) {
        this.header = header;
    }

    public void setBody(@Nullable Collection<GlslNode> body) {
        this.body = body != null ? new ArrayList<GlslNode>(body) : null;
    }

    public void setBody(GlslNode ... body) {
        this.body = body != null ? new ArrayList<GlslNode>(Arrays.asList(body)) : null;
    }

    @Override
    public String getSourceString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.header.getSourceString());
        if (this.body == null) {
            return builder + ";";
        }
        builder.append(" {\n");
        for (GlslNode node : this.body) {
            builder.append('\t').append(node.getSourceString().replaceAll("\n", "\n\t")).append(";\n");
        }
        builder.append("}\n");
        return builder.toString();
    }

    public String toString() {
        return "GlslFunction{header=" + this.header + ", body=" + this.body + "}";
    }
}

