/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.ui.util;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.util.Mth;

public class PoseStackAnimator {
    private final PoseStack poseStack;
    private final List<AnimationStage> stages = new ArrayList<AnimationStage>();
    private int currentStageIndex = -1;
    private long stageStartTime;

    public PoseStackAnimator(PoseStack poseStack) {
        this.poseStack = poseStack;
    }

    public void addStage(long durationMillis, BiConsumer<Long, PoseStack> transform) {
        this.stages.add(new AnimationStage(durationMillis, transform));
    }

    public void startAnimation() {
        this.currentStageIndex = 0;
        this.stageStartTime = System.currentTimeMillis();
    }

    public void tickAnimation() {
        if (this.isAnimating()) {
            AnimationStage currentStage = this.stages.get(this.currentStageIndex);
            long elapsedStageTime = System.currentTimeMillis() - this.stageStartTime;
            float progress = Mth.m_14036_((float)((float)elapsedStageTime / (float)currentStage.durationMillis), (float)0.0f, (float)1.0f);
            this.applyStageTransform(currentStage, progress);
            if (progress >= 1.0f && this.currentStageIndex < this.stages.size() - 1) {
                ++this.currentStageIndex;
                this.stageStartTime = System.currentTimeMillis();
            } else if (progress >= 1.0f) {
                this.resetAnimation();
            }
        }
    }

    public boolean isAnimating() {
        return this.currentStageIndex >= 0 && this.currentStageIndex < this.stages.size();
    }

    public void resetAnimation() {
        this.currentStageIndex = -1;
        this.stages.clear();
    }

    private void applyStageTransform(AnimationStage stage, float progress) {
        this.poseStack.m_85836_();
        long elapsedStageTime = (long)(progress * (float)stage.durationMillis);
        stage.transform.accept(elapsedStageTime, this.poseStack);
        this.poseStack.m_85849_();
    }

    private static class AnimationStage {
        long durationMillis;
        BiConsumer<Long, PoseStack> transform;

        AnimationStage(long durationMillis, BiConsumer<Long, PoseStack> transform) {
            this.durationMillis = durationMillis;
            this.transform = transform;
        }
    }
}

