/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil;

import foundry.veil.api.client.imgui.VeilImGui;
import foundry.veil.api.molang.VeilMolang;
import foundry.veil.impl.client.imgui.VeilImGuiImpl;
import foundry.veil.platform.VeilPlatform;
import gg.moonflower.molangcompiler.api.MolangCompiler;
import java.util.ServiceLoader;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Veil {
    public static final String MODID = "veil";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Veil");
    public static final boolean DEBUG;
    public static final boolean IMGUI;
    public static final boolean VERBOSE_SHADER_ERRORS;
    private static final VeilPlatform PLATFORM;
    public static final boolean SODIUM;

    @ApiStatus.Internal
    public static void init() {
        LOGGER.info("Veil is initializing.");
        if (DEBUG) {
            LOGGER.info("Veil Debug Enabled");
        }
        if (!IMGUI) {
            LOGGER.info("ImGui Disabled");
        }
        VeilMolang.set(MolangCompiler.create((int)1, (ClassLoader)Veil.class.getClassLoader()));
    }

    public static void withImGui(Runnable task) {
        Veil.beginImGui();
        task.run();
        Veil.endImGui();
    }

    public static VeilImGui beginImGui() {
        VeilImGui imGui = VeilImGuiImpl.get();
        imGui.begin();
        return imGui;
    }

    public static void endImGui() {
        VeilImGuiImpl.get().end();
    }

    public static ResourceLocation veilPath(String path) {
        return new ResourceLocation(MODID, path);
    }

    public static VeilPlatform platform() {
        return PLATFORM;
    }

    static {
        PLATFORM = ServiceLoader.load(VeilPlatform.class).findFirst().orElseThrow(() -> new RuntimeException("Veil expected platform implementation"));
        SODIUM = PLATFORM.isSodiumLoaded();
        DEBUG = System.getProperty("veil.debug") != null;
        IMGUI = System.getProperty("veil.disableImgui") == null;
        VERBOSE_SHADER_ERRORS = System.getProperty("veil.verboseShaderErrors") != null;
    }
}

