/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge.platform;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Lifecycle;
import foundry.veil.platform.registry.RegistrationProvider;
import foundry.veil.platform.registry.RegistryObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryBuilder;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ForgeRegistrationFactory
implements RegistrationProvider.Factory {
    @Override
    public <T> RegistrationProvider<T> create(ResourceKey<? extends Registry<T>> resourceKey, String modId) {
        RegistryBuilder registryFactory = RegistryManager.ACTIVE.getRegistry(resourceKey) == null && !BuiltInRegistries.f_257047_.m_7804_(resourceKey.m_135782_()) ? RegistryBuilder.of().disableSaving().disableSync().setName(resourceKey.m_135782_()) : null;
        return new Provider(modId, resourceKey, registryFactory, FMLJavaModLoadingContext.get().getModEventBus());
    }

    private static class Provider<T>
    implements RegistrationProvider<T> {
        private final String modId;
        private final ResourceKey<? extends Registry<T>> resourceKey;
        private final RegistryWrapper<T> wrapper;
        private final Map<ForgeRegistryObject<T>, Supplier<? extends T>> entries = new HashMap<ForgeRegistryObject<T>, Supplier<? extends T>>();
        private final Set<RegistryObject<T>> entriesView = Collections.unmodifiableSet(this.entries.keySet());

        private Provider(String modId, ResourceKey<? extends Registry<T>> resourceKey, @Nullable RegistryBuilder<T> registryFactory, IEventBus bus) {
            this.modId = modId;
            this.resourceKey = resourceKey;
            this.wrapper = new RegistryWrapper(resourceKey);
            bus.register((Object)this);
            if (registryFactory != null) {
                bus.addListener(event -> event.create(registryFactory));
            }
        }

        @SubscribeEvent
        public void register(RegisterEvent event) {
            if (event.getRegistryKey().equals(this.resourceKey)) {
                for (Map.Entry entry : this.entries.entrySet()) {
                    ForgeRegistryObject<T> object = entry.getKey();
                    event.register(this.resourceKey, object.getId(), () -> ((Supplier)entry.getValue()).get());
                    IForgeRegistry forgeRegistry = event.getForgeRegistry();
                    if (forgeRegistry != null) {
                        object.updateReference(forgeRegistry);
                        continue;
                    }
                    Registry vanillaRegistry = event.getVanillaRegistry();
                    if (vanillaRegistry == null) continue;
                    object.updateReference(vanillaRegistry);
                }
            }
        }

        @Override
        public String getModId() {
            return this.modId;
        }

        @Override
        public <I extends T> RegistryObject<I> register(ResourceLocation id, Supplier<? extends I> supplier) {
            ForgeRegistryObject ro = new ForgeRegistryObject(ResourceKey.m_135785_(this.resourceKey, (ResourceLocation)id));
            this.entries.put(ro, supplier);
            return ro;
        }

        @Override
        public Set<RegistryObject<T>> getEntries() {
            return this.entriesView;
        }

        @Override
        public Registry<T> asVanillaRegistry() {
            return this.wrapper;
        }
    }

    private record RegistryWrapper<T>(ResourceKey<? extends Registry<T>> resourceKey) implements Registry<T>
    {
        private IForgeRegistry<T> getRegistry() {
            return RegistryManager.ACTIVE.getRegistry(this.resourceKey);
        }

        @Nullable
        public T m_7745_(@Nullable ResourceLocation name) {
            IForgeRegistry<T> forgeRegistry = this.getRegistry();
            if (name == null && (name = forgeRegistry.getDefaultKey()) == null) {
                return null;
            }
            return (T)forgeRegistry.getValue(name);
        }

        @Nullable
        public T m_6246_(@Nullable ResourceKey<T> name) {
            return this.m_7745_(name != null ? name.m_135782_() : null);
        }

        public ResourceKey<? extends Registry<T>> m_123023_() {
            return this.resourceKey;
        }

        @Nullable
        public ResourceLocation m_7981_(@NotNull T value) {
            return this.getRegistry().getKey(value);
        }

        @NotNull
        public Optional<ResourceKey<T>> m_7854_(@NotNull T value) {
            return this.getRegistry().getResourceKey(value);
        }

        public boolean m_7804_(@NotNull ResourceLocation key) {
            return this.getRegistry().containsKey(key);
        }

        public boolean m_142003_(@NotNull ResourceKey<T> key) {
            return this.resourceKey.m_211136_().equals((Object)key.m_211136_()) && this.m_7804_(key.m_135782_());
        }

        public int m_7447_(@Nullable T value) {
            return value != null ? RegistryManager.ACTIVE.getRegistry(this.resourceKey).getID(value) : -1;
        }

        @Nullable
        public T m_7942_(int id) {
            return (T)RegistryManager.ACTIVE.getRegistry(this.resourceKey).getValue(id);
        }

        public Lifecycle m_6228_(T value) {
            return Lifecycle.stable();
        }

        public Lifecycle m_203658_() {
            return Lifecycle.stable();
        }

        public Iterator<T> iterator() {
            return this.getRegistry().iterator();
        }

        public Set<ResourceLocation> m_6566_() {
            return this.getRegistry().getKeys();
        }

        public Set<ResourceKey<T>> m_214010_() {
            return this.getRegistry().getEntries().stream().map(Map.Entry::getKey).collect(Collectors.toSet());
        }

        public Set<Map.Entry<ResourceKey<T>, T>> m_6579_() {
            return this.getRegistry().getEntries();
        }

        public int m_13562_() {
            return this.getRegistry().getEntries().size();
        }

        @NotNull
        public Optional<Holder.Reference<T>> m_203300_(int id) {
            throw new UnsupportedOperationException("Holders are not supported");
        }

        @NotNull
        public Optional<Holder.Reference<T>> m_203636_(ResourceKey<T> key) {
            throw new UnsupportedOperationException("Holders are not supported");
        }

        @NotNull
        public Holder<T> m_263177_(@NotNull T value) {
            throw new UnsupportedOperationException("Holders are not supported");
        }

        public Optional<Holder.Reference<T>> m_213642_(RandomSource rand) {
            throw new UnsupportedOperationException("Holders are not supported");
        }

        public Stream<Holder.Reference<T>> m_203611_() {
            throw new UnsupportedOperationException("Holders are not supported");
        }

        public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> m_203612_() {
            throw new UnsupportedOperationException("Tags are not supported");
        }

        public HolderSet.Named<T> m_203561_(TagKey<T> name) {
            throw new UnsupportedOperationException("Tags are not supported");
        }

        public Stream<TagKey<T>> m_203613_() {
            throw new UnsupportedOperationException("Tags are not supported");
        }

        public Registry<T> m_203521_() {
            return this;
        }

        public Holder.Reference<T> m_203693_(T value) {
            throw new UnsupportedOperationException("Intrusive holders are not supported");
        }

        public Optional<HolderSet.Named<T>> m_203431_(TagKey<T> name) {
            throw new UnsupportedOperationException("Tags are not supported");
        }

        public void m_203652_(Map<TagKey<T>, List<Holder<T>>> newTags) {
            throw new UnsupportedOperationException("Tags are not supported");
        }

        public HolderOwner<T> m_255331_() {
            throw new UnsupportedOperationException("Holders are not supported");
        }

        public HolderLookup.RegistryLookup<T> m_255303_() {
            throw new UnsupportedOperationException("Holders are not supported");
        }

        public void m_203635_() {
            throw new UnsupportedOperationException("Tags are not supported");
        }
    }

    private static class ForgeRegistryObject<I>
    implements RegistryObject<I> {
        private final ResourceKey<I> key;
        private I value;
        private Holder<I> holder;

        private ForgeRegistryObject(ResourceKey<I> key) {
            this.key = key;
        }

        private void updateReference(IForgeRegistry<I> registry) {
            if (this.key != null && registry.containsKey(this.key.m_135782_())) {
                this.value = registry.getValue(this.key.m_135782_());
                this.holder = registry.getHolder(this.key).orElse(null);
            }
        }

        private void updateReference(Registry<I> registry) {
            if (this.key != null && registry.m_7804_(this.key.m_135782_())) {
                this.value = registry.m_6246_(this.key);
                this.holder = registry.m_203636_(this.key).orElse(null);
            }
        }

        @Override
        public ResourceKey<I> getResourceKey() {
            return this.key;
        }

        @Override
        public ResourceLocation getId() {
            return this.key.m_135782_();
        }

        @Override
        public boolean isPresent() {
            return this.value != null;
        }

        @Override
        public I get() {
            return Objects.requireNonNull(this.value, () -> "Registry Object not present: " + this.key.m_135782_());
        }

        @Override
        public Holder<I> asHolder() {
            return this.holder;
        }
    }
}

