/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import foundry.veil.api.client.editor.EditorAttributeProvider;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.imgui.VeilImGuiUtil;
import foundry.veil.api.client.registry.LightTypeRegistry;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.light.Light;
import foundry.veil.api.client.render.deferred.light.renderer.LightRenderer;
import imgui.ImGui;
import imgui.type.ImBoolean;
import imgui.type.ImFloat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3fc;

public class LightEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.m_237115_((String)"editor.veil.deferred_light.title");
    private static final Component ADD = Component.m_237115_((String)"editor.veil.deferred_light.button.add");
    private static final Component REMOVE = Component.m_237115_((String)"editor.veil.deferred_light.button.remove");
    private static final Component REMOVE_ALL = Component.m_237115_((String)"editor.veil.deferred_light.button.remove_all");
    private static final Component REMOVE_ALL_DESC = Component.m_237115_((String)"editor.veil.deferred_light.button.remove_all.desc");
    private static final Component SET_POSITION = Component.m_237115_((String)"editor.veil.deferred_light.button.set_position");
    private static final Component ATTRIBUTES = Component.m_237115_((String)"editor.veil.deferred_light.attributes");
    private final List<ResourceKey<LightTypeRegistry.LightType<?>>> lightTypes = new ArrayList();
    private ResourceKey<LightTypeRegistry.LightType<?>> selectedTab;

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    @Nullable
    public Component getGroup() {
        return DEFERRED_GROUP;
    }

    @Override
    public boolean isEnabled() {
        return VeilRenderSystem.renderer().getDeferredRenderer().isEnabled() && Minecraft.m_91087_().f_91073_ != null && LightTypeRegistry.REGISTRY.m_13562_() > 0;
    }

    @Override
    protected void renderComponents() {
        LightTypeRegistry.LightType lightType;
        LightRenderer lightRenderer = VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer();
        if (this.selectedTab == null || !LightTypeRegistry.REGISTRY.m_142003_(this.selectedTab)) {
            this.selectedTab = this.lightTypes.get(0);
        }
        ImGui.beginDisabled(((lightType = (LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.m_6246_(this.selectedTab)) == null || lightType.debugLightFactory() == null ? 1 : 0) != 0);
        if (ImGui.button((String)ADD.getString()) && lightType != null && lightType.debugLightFactory() != null) {
            LightTypeRegistry.DebugLightFactory factory = lightType.debugLightFactory();
            Minecraft minecraft = Minecraft.m_91087_();
            Camera mainCamera = minecraft.f_91063_.m_109153_();
            lightRenderer.addLight(factory.createDebugLight(minecraft.f_91073_, mainCamera));
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((FormattedText)Component.m_237110_((String)"editor.veil.deferred_light.button.add.desc", (Object[])new Object[]{this.selectedTab.m_135782_().toString()}));
        }
        ImGui.sameLine();
        ImGui.beginDisabled((lightType == null ? 1 : 0) != 0);
        if (ImGui.button((String)REMOVE.getString()) && lightType != null) {
            for (Light light : lightRenderer.getLights(lightType)) {
                lightRenderer.removeLight(light);
            }
        }
        ImGui.endDisabled();
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((FormattedText)Component.m_237110_((String)"editor.veil.deferred_light.button.remove.desc", (Object[])new Object[]{this.selectedTab.m_135782_().toString()}));
        }
        ImGui.sameLine();
        if (ImGui.button((String)REMOVE_ALL.getString())) {
            lightRenderer.free();
        }
        if (ImGui.isItemHovered((int)0)) {
            VeilImGuiUtil.setTooltip((FormattedText)REMOVE_ALL_DESC);
        }
        ImGui.beginTabBar((String)"##lights");
        for (ResourceKey resourceKey : this.lightTypes) {
            ResourceLocation id = resourceKey.m_135782_();
            if (!ImGui.beginTabItem((String)id.toString())) continue;
            this.selectedTab = resourceKey;
            List lights = lightRenderer.getLights((LightTypeRegistry.LightType)LightTypeRegistry.REGISTRY.m_6246_(resourceKey));
            for (int i = 0; i < lights.size(); ++i) {
                ImGui.pushID((String)("light" + i));
                LightEditor.renderLightComponents((Light)lights.get(i));
                ImGui.popID();
            }
            ImGui.endTabItem();
        }
        ImGui.endTabBar();
    }

    @Override
    public void onShow() {
        super.onShow();
        this.lightTypes.clear();
        this.lightTypes.addAll(LightTypeRegistry.REGISTRY.m_214010_().stream().sorted(Comparator.comparing(ResourceKey::m_135782_)).toList());
    }

    private static void renderLightComponents(Light light) {
        ImBoolean visible = new ImBoolean(true);
        ImGui.pushID((int)light.hashCode());
        if (ImGui.collapsingHeader((String)"0x%X".formatted(light.hashCode()), (ImBoolean)visible)) {
            LightEditor.renderLightAttributeComponents(light);
        }
        ImGui.popID();
        if (!visible.get()) {
            VeilRenderSystem.renderer().getDeferredRenderer().getLightRenderer().removeLight(light);
        }
        ImGui.separator();
    }

    private static void renderLightAttributeComponents(Light light) {
        Vector3fc lightColor = light.getColor();
        ImFloat editBrightness = new ImFloat(light.getBrightness());
        float[] editLightColor = new float[]{lightColor.x(), lightColor.y(), lightColor.z()};
        ImGui.indent();
        if (ImGui.dragScalar((String)"brightness", (int)8, (ImFloat)editBrightness, (float)0.02f)) {
            light.setBrightness(editBrightness.get());
        }
        if (ImGui.colorEdit3((String)"color", (float[])editLightColor)) {
            light.setColor(editLightColor[0], editLightColor[1], editLightColor[2]);
        }
        if (ImGui.button((String)SET_POSITION.getString())) {
            light.setTo(Minecraft.m_91087_().f_91063_.m_109153_());
        }
        ImGui.newLine();
        VeilImGuiUtil.component((FormattedText)ATTRIBUTES);
        if (light instanceof EditorAttributeProvider) {
            EditorAttributeProvider editorAttributeProvider = (EditorAttributeProvider)((Object)light);
            editorAttributeProvider.renderImGuiAttributes();
        }
        ImGui.unindent();
    }
}

