/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.lib.opencl;

import java.nio.ByteBuffer;
import javax.annotation.Nullable;
import org.lwjgl.BufferUtils;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;
import org.lwjgl.system.NativeResource;
import org.lwjgl.system.NativeType;
import org.lwjgl.system.Struct;
import org.lwjgl.system.StructBuffer;

@NativeType(value="struct cl_name_version_khr")
public class CLNameVersionKHR
extends Struct
implements NativeResource {
    public static final int SIZEOF;
    public static final int ALIGNOF;
    public static final int VERSION;
    public static final int NAME;

    public CLNameVersionKHR(ByteBuffer container) {
        super(MemoryUtil.memAddress(container), CLNameVersionKHR.__checkContainer(container, SIZEOF));
    }

    @Override
    public int sizeof() {
        return SIZEOF;
    }

    @NativeType(value="cl_version_khr")
    public int version() {
        return CLNameVersionKHR.nversion(this.address());
    }

    @NativeType(value="char[64]")
    public ByteBuffer name() {
        return CLNameVersionKHR.nname(this.address());
    }

    @NativeType(value="char[64]")
    public String nameString() {
        return CLNameVersionKHR.nnameString(this.address());
    }

    public static CLNameVersionKHR malloc() {
        return CLNameVersionKHR.wrap(CLNameVersionKHR.class, MemoryUtil.nmemAllocChecked(SIZEOF));
    }

    public static CLNameVersionKHR calloc() {
        return CLNameVersionKHR.wrap(CLNameVersionKHR.class, MemoryUtil.nmemCallocChecked(1L, SIZEOF));
    }

    public static CLNameVersionKHR create() {
        ByteBuffer container = BufferUtils.createByteBuffer(SIZEOF);
        return CLNameVersionKHR.wrap(CLNameVersionKHR.class, MemoryUtil.memAddress(container), container);
    }

    public static CLNameVersionKHR create(long address) {
        return CLNameVersionKHR.wrap(CLNameVersionKHR.class, address);
    }

    @Nullable
    public static CLNameVersionKHR createSafe(long address) {
        return address == 0L ? null : CLNameVersionKHR.wrap(CLNameVersionKHR.class, address);
    }

    public static Buffer malloc(int capacity) {
        return CLNameVersionKHR.wrap(Buffer.class, MemoryUtil.nmemAllocChecked(CLNameVersionKHR.__checkMalloc(capacity, SIZEOF)), capacity);
    }

    public static Buffer calloc(int capacity) {
        return CLNameVersionKHR.wrap(Buffer.class, MemoryUtil.nmemCallocChecked(capacity, SIZEOF), capacity);
    }

    public static Buffer create(int capacity) {
        ByteBuffer container = CLNameVersionKHR.__create(capacity, SIZEOF);
        return CLNameVersionKHR.wrap(Buffer.class, MemoryUtil.memAddress(container), capacity, container);
    }

    public static Buffer create(long address, int capacity) {
        return CLNameVersionKHR.wrap(Buffer.class, address, capacity);
    }

    @Nullable
    public static Buffer createSafe(long address, int capacity) {
        return address == 0L ? null : CLNameVersionKHR.wrap(Buffer.class, address, capacity);
    }

    public static CLNameVersionKHR malloc(MemoryStack stack) {
        return CLNameVersionKHR.wrap(CLNameVersionKHR.class, stack.nmalloc(ALIGNOF, SIZEOF));
    }

    public static CLNameVersionKHR calloc(MemoryStack stack) {
        return CLNameVersionKHR.wrap(CLNameVersionKHR.class, stack.ncalloc(ALIGNOF, 1, SIZEOF));
    }

    public static Buffer malloc(int capacity, MemoryStack stack) {
        return CLNameVersionKHR.wrap(Buffer.class, stack.nmalloc(ALIGNOF, capacity * SIZEOF), capacity);
    }

    public static Buffer calloc(int capacity, MemoryStack stack) {
        return CLNameVersionKHR.wrap(Buffer.class, stack.ncalloc(ALIGNOF, capacity, SIZEOF), capacity);
    }

    public static int nversion(long struct) {
        return UNSAFE.getInt(null, struct + (long)VERSION);
    }

    public static ByteBuffer nname(long struct) {
        return MemoryUtil.memByteBuffer(struct + (long)NAME, 64);
    }

    public static String nnameString(long struct) {
        return MemoryUtil.memASCII(struct + (long)NAME);
    }

    static {
        Struct.Layout layout = CLNameVersionKHR.__struct(CLNameVersionKHR.__member(4), CLNameVersionKHR.__array(1, 64));
        SIZEOF = layout.getSize();
        ALIGNOF = layout.getAlignment();
        VERSION = layout.offsetof(0);
        NAME = layout.offsetof(1);
    }

    public static class Buffer
    extends StructBuffer<CLNameVersionKHR, Buffer>
    implements NativeResource {
        private static final CLNameVersionKHR ELEMENT_FACTORY = CLNameVersionKHR.create(-1L);

        public Buffer(ByteBuffer container) {
            super(container, container.remaining() / SIZEOF);
        }

        public Buffer(long address, int cap) {
            super(address, null, -1, 0, cap, cap);
        }

        Buffer(long address, @Nullable ByteBuffer container, int mark, int pos, int lim, int cap) {
            super(address, container, mark, pos, lim, cap);
        }

        @Override
        protected Buffer self() {
            return this;
        }

        @Override
        protected CLNameVersionKHR getElementFactory() {
            return ELEMENT_FACTORY;
        }

        @NativeType(value="cl_version_khr")
        public int version() {
            return CLNameVersionKHR.nversion(this.address());
        }

        @NativeType(value="char[64]")
        public ByteBuffer name() {
            return CLNameVersionKHR.nname(this.address());
        }

        @NativeType(value="char[64]")
        public String nameString() {
            return CLNameVersionKHR.nnameString(this.address());
        }
    }
}

