/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.render;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import foundry.veil.api.client.color.Color;
import foundry.veil.api.client.color.theme.NumberThemeProperty;
import foundry.veil.api.client.tooltip.Tooltippable;
import foundry.veil.api.client.tooltip.VeilUIItemTooltipDataHolder;
import foundry.veil.api.client.util.SpaceHelper;
import foundry.veil.api.client.util.UIUtils;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@ApiStatus.Internal
public class VeilUITooltipRenderer {
    public static int hoverTicks = 0;
    public static Vec3 lastHoveredPos = null;
    public static Vec3 currentPos = null;
    public static Vec3 desiredPos = null;

    public static void renderOverlay(Gui gui, GuiGraphics graphics, float partialTicks, int width, int height) {
        int n;
        ItemStack istack;
        BlockHitResult blockHitResult;
        BlockEntity blockEntity;
        EntityHitResult entityHitResult;
        Entity entity;
        PoseStack stack = graphics.m_280168_();
        stack.m_85836_();
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91066_.f_92062_ || mc.f_91072_.m_105295_() == GameType.SPECTATOR) {
            return;
        }
        HitResult result = mc.f_91077_;
        Vec3 pos = null;
        Tooltippable tooltippable = null;
        if (result instanceof EntityHitResult && (entity = (entityHitResult = (EntityHitResult)result).m_82443_()) instanceof Tooltippable) {
            Tooltippable tooltippable1;
            tooltippable = tooltippable1 = (Tooltippable)entity;
            pos = entityHitResult.m_82443_().m_20318_(0.0f).m_82520_(0.0, (double)(entityHitResult.m_82443_().m_20192_() / 2.0f), 0.0);
        }
        if (result instanceof BlockHitResult && (blockEntity = mc.f_91073_.m_7702_(BlockPos.m_274446_((Position)(pos = Vec3.m_82512_((Vec3i)(blockHitResult = (BlockHitResult)result).m_82425_()))))) instanceof Tooltippable) {
            Tooltippable tooltippable1 = (Tooltippable)blockEntity;
            tooltippable = tooltippable1;
        }
        if (tooltippable == null || !tooltippable.isTooltipEnabled()) {
            hoverTicks = 0;
            lastHoveredPos = null;
            return;
        }
        ++hoverTicks;
        lastHoveredPos = pos;
        List<Component> tooltip = tooltippable.getTooltip();
        if (tooltip.isEmpty()) {
            hoverTicks = 0;
            return;
        }
        stack.m_85836_();
        int tooltipTextWidth = 0;
        for (FormattedText formattedText : tooltip) {
            int textLineWidth = mc.f_91062_.m_92852_(formattedText);
            if (textLineWidth <= tooltipTextWidth) continue;
            tooltipTextWidth = textLineWidth;
        }
        int tooltipHeight = 8;
        if (tooltip.size() > 1) {
            tooltipHeight += 2 + (tooltip.size() - 1) * 10;
        }
        int n2 = width / 2 + 20;
        int tooltipY = height / 2;
        int desiredX = n2;
        int desiredY = tooltipY;
        int n3 = Math.min(n2, width - tooltipTextWidth - 20);
        tooltipY = Math.min(tooltipY, height - tooltipHeight - 20);
        float fade = Mth.m_14036_((float)(((float)hoverTicks + partialTicks) / 24.0f), (float)0.0f, (float)1.0f);
        Color background = tooltippable.getTheme().getColor("background");
        Color borderTop = tooltippable.getTheme().getColor("topBorder");
        Color borderBottom = tooltippable.getTheme().getColor("bottomBorder");
        float heightBonus = tooltippable.getTooltipHeight();
        float widthBonus = tooltippable.getTooltipWidth();
        float textXOffset = tooltippable.getTooltipXOffset();
        float textYOffset = tooltippable.getTooltipYOffset();
        List<VeilUIItemTooltipDataHolder> items = tooltippable.getItems();
        ItemStack itemStack = istack = tooltippable.getStack() == null ? ItemStack.f_41583_ : tooltippable.getStack();
        if (pos != lastHoveredPos) {
            currentPos = null;
            desiredPos = null;
        }
        if (tooltippable.getWorldspace()) {
            currentPos = currentPos == null ? pos : currentPos;
            Vec3 playerPos = mc.f_91063_.m_109153_().m_90583_();
            Vec3i playerPosInt = new Vec3i((int)playerPos.f_82479_, (int)playerPos.f_82480_, (int)playerPos.f_82481_);
            Vec3i cornerInt = new Vec3i((int)pos.f_82479_, (int)pos.f_82480_, (int)pos.f_82481_);
            Vec3i diff = playerPosInt.m_121996_(cornerInt);
            desiredPos = pos.m_82520_((double)((float)Math.round((float)Mth.m_14045_((int)Math.round(diff.m_123341_()), (int)-1, (int)1) * 0.5f) - 0.5f), 0.5, (double)((float)Math.round((float)Mth.m_14045_((int)Math.round(diff.m_123343_()), (int)-1, (int)1) * 0.5f) - 0.5f));
            if (fade == 0.0f) {
                currentPos = currentPos.m_82520_(0.0, -0.25, 0.0);
                background = background.multiply(1.0f, 1.0f, 1.0f, fade);
                borderTop = borderTop.multiply(1.0f, 1.0f, 1.0f, fade);
                borderBottom = borderBottom.multiply(1.0f, 1.0f, 1.0f, fade);
            }
            currentPos = currentPos.m_165921_(desiredPos, (double)0.05f);
            Vector3f screenSpacePos = SpaceHelper.worldToScreenSpace(currentPos, partialTicks);
            Vector3f desiredScreenSpacePos = SpaceHelper.worldToScreenSpace(desiredPos, partialTicks);
            float f = Mth.m_14036_((float)screenSpacePos.x(), (float)0.0f, (float)width);
            float f2 = screenSpacePos.y();
            Objects.requireNonNull(mc.f_91062_);
            screenSpacePos = new Vector3f(f, Mth.m_14036_((float)f2, (float)0.0f, (float)(height - 9 * tooltip.size())), screenSpacePos.z());
            float f3 = Mth.m_14036_((float)desiredScreenSpacePos.x(), (float)0.0f, (float)width);
            float f4 = desiredScreenSpacePos.y();
            Objects.requireNonNull(mc.f_91062_);
            desiredScreenSpacePos = new Vector3f(f3, Mth.m_14036_((float)f4, (float)0.0f, (float)(height - 9 * tooltip.size())), desiredScreenSpacePos.z());
            n = (int)screenSpacePos.x();
            tooltipY = (int)screenSpacePos.y();
            desiredX = (int)desiredScreenSpacePos.x();
            desiredY = (int)desiredScreenSpacePos.y();
        }
        UIUtils.drawHoverText(tooltippable, partialTicks, istack, stack, tooltip, (int)(n + (int)textXOffset), tooltipY + (int)textYOffset, width, height, -1, background.getHex(), borderTop.getHex(), borderBottom.getHex(), mc.f_91062_, (int)widthBonus, (int)heightBonus, items, desiredX, desiredY);
        stack.m_85849_();
    }

    public static void drawConnectionLine(PoseStack stack, Tooltippable tooltippable, int tooltipX, int tooltipY, int desiredX, int desiredY) {
        if (tooltippable.getTheme().getColor("connectingLine") != null) {
            stack.m_85836_();
            Color color = tooltippable.getTheme().getColor("connectingLine");
            float thickness = ((NumberThemeProperty)tooltippable.getTheme().getProperty("connectingLineThickness")).getValue(Float.class).floatValue();
            Matrix4f mat = stack.m_85850_().m_252922_();
            RenderSystem.enableDepthTest();
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.lineWidth((float)2.0f);
            RenderSystem.setShader(GameRenderer::m_172811_);
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
            buffer.m_252986_(mat, (float)desiredX + thickness, (float)desiredY, 399.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)desiredX - thickness, (float)desiredY, 399.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)tooltipX - thickness, (float)(tooltipY + 3) - (float)tooltippable.getTooltipHeight() / 2.0f, 399.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            buffer.m_252986_(mat, (float)tooltipX + thickness, (float)(tooltipY + 3) - (float)tooltippable.getTooltipHeight() / 2.0f, 399.0f).m_85950_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).m_5752_();
            Tesselator.m_85913_().m_85914_();
            RenderSystem.disableBlend();
            stack.m_85849_();
        }
    }
}

