/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.emitters.module.render;

import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.deferred.light.PointLight;
import foundry.veil.api.quasar.data.module.init.LightModuleData;
import foundry.veil.api.quasar.emitters.module.RenderParticleModule;
import foundry.veil.api.quasar.emitters.module.UpdateParticleModule;
import foundry.veil.api.quasar.particle.QuasarParticle;
import net.minecraft.util.Mth;
import org.joml.Vector4f;
import org.joml.Vector4fc;

public class DynamicLightModule
implements UpdateParticleModule,
RenderParticleModule {
    private final LightModuleData data;
    private float brightness;
    private float lastRadius;
    private float radius;
    private final Vector4f lastColor;
    private final Vector4f color;
    private final Vector4f renderColor;
    private float lastBrightness;
    private PointLight light;
    private boolean enabled;
    private final boolean constantColor;
    private final boolean constantBrightness;
    private final boolean constantRadius;

    public DynamicLightModule(LightModuleData data) {
        this.data = data;
        this.constantColor = data.color().isConstant();
        this.constantBrightness = this.constantColor && data.brightness().isConstant();
        this.constantRadius = data.radius().isConstant();
        this.lastColor = new Vector4f(1.0f);
        this.color = new Vector4f(1.0f);
        this.renderColor = new Vector4f(1.0f);
        this.light = null;
        if (this.constantColor) {
            data.color().getColor(0.0f, this.color);
            this.lastColor.set((Vector4fc)this.color);
            this.renderColor.set((Vector4fc)this.color);
        }
    }

    @Override
    public void update(QuasarParticle particle) {
        VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
        this.enabled = deferredRenderer.isEnabled();
        if (!this.enabled) {
            this.onRemove();
            return;
        }
        if (!this.constantColor) {
            this.lastColor.set((Vector4fc)this.color);
            this.data.color().getColor((float)particle.getAge() / (float)particle.getLifetime(), this.color);
        }
        if (!this.constantBrightness) {
            this.lastBrightness = this.brightness;
            this.brightness = particle.getEnvironment().safeResolve(this.data.brightness());
        }
        if (!this.constantRadius) {
            this.lastRadius = this.radius;
            this.radius = particle.getEnvironment().safeResolve(this.data.radius());
        }
        float brightness = this.brightness * this.color.w;
        if ((double)this.color.lengthSquared() < 0.1 && (double)brightness < 0.1) {
            this.onRemove();
            return;
        }
        if (this.light == null) {
            this.light = new PointLight();
            if (this.constantColor) {
                this.light.setColor(this.color.x, this.color.y, this.color.z);
            }
            if (this.constantBrightness) {
                this.light.setBrightness(this.brightness * this.renderColor.w);
            }
            if (this.constantRadius) {
                this.light.setBrightness(this.radius);
            }
            deferredRenderer.getLightRenderer().addLight(this.light);
        }
        this.lastBrightness = brightness;
    }

    @Override
    public void render(QuasarParticle particle, float partialTicks) {
        if (this.light == null) {
            return;
        }
        this.light.setPosition(particle.getRenderData().getRenderPosition());
        if (!this.constantColor) {
            this.lastColor.lerp((Vector4fc)this.color, partialTicks, this.renderColor);
            this.light.setColor(this.renderColor.x, this.renderColor.y, this.renderColor.z);
        }
        if (!this.constantBrightness) {
            this.light.setBrightness(Mth.m_14179_((float)partialTicks, (float)this.lastBrightness, (float)this.brightness) * this.renderColor.w);
        }
        if (!this.constantRadius) {
            this.light.setRadius(Mth.m_14179_((float)partialTicks, (float)this.lastRadius, (float)this.radius));
        }
    }

    @Override
    public void onRemove() {
        if (this.light != null) {
            VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
            if (deferredRenderer.isEnabled()) {
                deferredRenderer.getLightRenderer().removeLight(this.light);
            }
            this.light = null;
        }
    }

    @Override
    public boolean isEnabled() {
        return this.enabled || VeilRenderSystem.renderer().getDeferredRenderer().isEnabled();
    }
}

