/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.impl.client.editor;

import com.mojang.blaze3d.systems.RenderSystem;
import foundry.veil.Veil;
import foundry.veil.api.client.editor.SingleWindowEditor;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.api.client.render.shader.VeilShaders;
import foundry.veil.api.client.render.shader.program.ShaderProgram;
import foundry.veil.api.client.util.TextureDownloader;
import imgui.ImGui;
import imgui.type.ImBoolean;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.ApiStatus;
import org.lwjgl.opengl.GL11C;
import org.lwjgl.opengl.GL20C;
import org.lwjgl.opengl.GL45C;
import org.lwjgl.system.NativeResource;

@ApiStatus.Internal
public class TextureEditor
extends SingleWindowEditor {
    public static final Component TITLE = Component.m_237115_((String)"editor.veil.texture.title");
    public static final Component DOWNLOAD = Component.m_237115_((String)"editor.veil.texture.button.download");
    public static final Component POP_OUT = Component.m_237115_((String)"editor.veil.texture.toggle.pop_out");
    public static final Component FLIP_X = Component.m_237115_((String)"editor.veil.texture.toggle.flip_x");
    public static final Component FLIP_Y = Component.m_237115_((String)"editor.veil.texture.toggle.flip_y");
    public static final Component NO_TEXTURE = Component.m_237115_((String)"editor.veil.texture.asset.missing");
    private final IntSet texturesSet = new IntArraySet();
    private final Int2ObjectMap<OpenTexture> openTextures = new Int2ObjectArrayMap();
    private final Int2ObjectMap<CubemapStorage> cubemapStorage = new Int2ObjectArrayMap();
    private final ImBoolean flipX = new ImBoolean();
    private final ImBoolean flipY = new ImBoolean();
    private int[] textures = new int[0];
    private int selectedTexture = 0;
    private boolean downloadTextures;
    private CompletableFuture<?> downloadFuture = null;

    private void scanTextures() {
        this.texturesSet.clear();
        for (int i = 0; i < 10000; ++i) {
            if (!GL20C.glIsTexture((int)i)) continue;
            this.texturesSet.add(i);
        }
        if (this.textures.length != this.texturesSet.size()) {
            if (!this.texturesSet.contains(this.selectedTexture)) {
                this.selectedTexture = 0;
            }
            this.textures = this.texturesSet.toIntArray();
            this.openTextures.keySet().removeIf(a -> !this.texturesSet.contains(a));
            ObjectIterator iterator = this.cubemapStorage.int2ObjectEntrySet().iterator();
            while (iterator.hasNext()) {
                Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
                if (this.texturesSet.contains(entry.getIntKey())) continue;
                ((CubemapStorage)entry.getValue()).free();
                iterator.remove();
            }
        }
    }

    @Override
    public Component getDisplayName() {
        return TITLE;
    }

    @Override
    public Component getGroup() {
        return RENDERER_GROUP;
    }

    @Override
    protected void renderComponents() {
        this.scanTextures();
        int selectedId = this.selectedTexture < 0 || this.selectedTexture >= this.textures.length ? 0 : this.textures[this.selectedTexture];
        int[] value = new int[]{this.selectedTexture};
        ImGui.beginDisabled(this.textures.length == 0);
        ImGui.setNextItemWidth(ImGui.getContentRegionAvailX() / 2.0f);
        if (ImGui.sliderInt("##textures", value, 0, this.textures.length - 1, selectedId == 0 ? NO_TEXTURE.getString() : Integer.toString(selectedId))) {
            this.selectedTexture = value[0];
        }
        ImGui.endDisabled();
        ImGui.sameLine();
        ImGui.pushButtonRepeat(true);
        ImGui.beginDisabled(this.selectedTexture <= 0);
        if (ImGui.arrowButton("##left", 0)) {
            --this.selectedTexture;
        }
        ImGui.endDisabled();
        ImGui.beginDisabled(this.selectedTexture >= this.textures.length - 1);
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.arrowButton("##right", 1)) {
            ++this.selectedTexture;
        }
        ImGui.endDisabled();
        ImGui.popButtonRepeat();
        ImGui.beginDisabled(this.downloadFuture != null && !this.downloadFuture.isDone());
        ImGui.sameLine();
        if (ImGui.button(DOWNLOAD.getString())) {
            this.downloadTextures = true;
            this.downloadFuture = new CompletableFuture();
        }
        ImGui.endDisabled();
        ImGui.beginDisabled(this.openTextures.containsKey(selectedId) && ((OpenTexture)this.openTextures.get((int)selectedId)).visible.get());
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        if (ImGui.button(POP_OUT.getString())) {
            this.openTextures.put(selectedId, (Object)new OpenTexture(this.flipX.get(), this.flipY.get()));
        }
        ImGui.endDisabled();
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.checkbox(FLIP_X.getString(), this.flipX);
        ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
        ImGui.checkbox(FLIP_Y.getString(), this.flipY);
        if (selectedId != 0) {
            this.addImage(selectedId, this.flipX.get(), this.flipY.get());
        }
    }

    @Override
    public void render() {
        super.render();
        ObjectIterator iterator = this.openTextures.int2ObjectEntrySet().iterator();
        while (iterator.hasNext()) {
            Int2ObjectMap.Entry entry = (Int2ObjectMap.Entry)iterator.next();
            int id = entry.getIntKey();
            OpenTexture texture = (OpenTexture)entry.getValue();
            if (!texture.visible.get()) continue;
            ImBoolean open = texture.open;
            if (!open.get()) {
                open.set(true);
                ImGui.setNextWindowSize(800.0f, 600.0f);
            }
            if (ImGui.begin(I18n.m_118938_((String)"editor.veil.texture.asset", (Object[])new Object[]{id}), open, 256)) {
                ImBoolean flipX = texture.flipX;
                ImBoolean flipY = texture.flipY;
                ImGui.checkbox(FLIP_X.getString(), flipX);
                ImGui.sameLine(0.0f, ImGui.getStyle().getItemInnerSpacingX());
                ImGui.checkbox(FLIP_Y.getString(), flipY);
                this.addImage(id, flipX.get(), flipY.get());
            }
            ImGui.end();
            if (open.get()) continue;
            iterator.remove();
        }
    }

    @Override
    public void renderLast() {
        super.renderLast();
        if (this.downloadTextures) {
            this.downloadTextures = false;
            try {
                Minecraft client = Minecraft.m_91087_();
                Path outputFolder = Paths.get(client.f_91069_.toURI()).resolve("debug-out");
                if (!Files.exists(outputFolder, new LinkOption[0])) {
                    Files.createDirectories(outputFolder, new FileAttribute[0]);
                } else {
                    Files.walkFileTree(outputFolder, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                        @Override
                        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                            Files.delete(file);
                            return FileVisitResult.CONTINUE;
                        }
                    });
                }
                LinkedList result = new LinkedList();
                IntIterator intIterator = this.texturesSet.iterator();
                while (intIterator.hasNext()) {
                    int i = (Integer)intIterator.next();
                    result.add(TextureDownloader.save(Integer.toString(i), outputFolder, i, false));
                }
                this.downloadFuture = CompletableFuture.allOf(result.toArray(new CompletableFuture[0])).thenRunAsync(() -> Util.m_137581_().m_137644_(outputFolder.toFile()), (Executor)client);
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to download textures", (Throwable)e);
            }
        }
    }

    @Override
    public void renderMenuBar() {
        for (Int2ObjectMap.Entry entry : this.openTextures.int2ObjectEntrySet()) {
            ImGui.menuItem(I18n.m_118938_((String)"editor.veil.texture.asset", (Object[])new Object[]{entry.getIntKey()}), null, ((OpenTexture)entry.getValue()).visible);
        }
    }

    @Override
    public boolean isMenuBarEnabled() {
        return !this.openTextures.isEmpty();
    }

    @Override
    public void onHide() {
        super.onHide();
        this.texturesSet.clear();
        this.cubemapStorage.values().forEach(CubemapStorage::free);
        this.cubemapStorage.clear();
        this.textures = new int[0];
        this.selectedTexture = 0;
    }

    private void addImage(int selectedId, boolean flipX, boolean flipY) {
        int target;
        int n = target = VeilRenderSystem.directStateAccessSupported() ? GL45C.glGetTextureParameteri((int)selectedId, (int)4102) : 3553;
        if (target == 34067) {
            CubemapStorage storage = (CubemapStorage)this.cubemapStorage.computeIfAbsent(selectedId, CubemapStorage::new);
            float size = ImGui.getContentRegionAvailX();
            storage.render((int)size, (int)(size / 2.0f));
            ImGui.image(storage.renderedTextureId(), size, size / 2.0f, flipX ? 1.0f : 0.0f, flipY ? 1.0f : 0.0f, flipX ? 0.0f : 1.0f, flipY ? 0.0f : 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        } else if (target == 3553) {
            CubemapStorage storage = (CubemapStorage)this.cubemapStorage.remove(selectedId);
            if (storage != null) {
                storage.free();
            }
            RenderSystem.bindTexture((int)selectedId);
            int width = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4096);
            int height = GL11C.glGetTexLevelParameteri((int)3553, (int)0, (int)4097);
            float size = ImGui.getContentRegionAvailX();
            ImGui.image(selectedId, size, size * (float)height / (float)width, flipX ? 1.0f : 0.0f, flipY ? 1.0f : 0.0f, flipX ? 0.0f : 1.0f, flipY ? 0.0f : 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private static final class CubemapStorage
    implements NativeResource {
        private final int texture;
        private AdvancedFbo fbo;

        private CubemapStorage(int texture) {
            this.texture = texture;
        }

        public void render(int width, int height) {
            ShaderProgram shaderProgram = VeilRenderSystem.setShader(VeilShaders.DEBUG_CUBEMAP);
            if (shaderProgram == null) {
                VeilRenderSystem.throwShaderError();
                this.free();
                return;
            }
            if (this.fbo == null || this.fbo.getWidth() != width || this.fbo.getHeight() != height) {
                this.free();
                this.fbo = AdvancedFbo.withSize(width, height).addColorTextureBuffer().setDepthRenderBuffer().build(true);
            }
            this.fbo.bind(true);
            this.fbo.clear();
            GL11C.glBindTexture((int)34067, (int)this.texture);
            shaderProgram.bind();
            VeilRenderSystem.drawScreenQuad();
            AdvancedFbo.unbind();
        }

        public int renderedTextureId() {
            return this.fbo.getColorTextureAttachment(0).m_117963_();
        }

        @Override
        public void free() {
            if (this.fbo != null) {
                this.fbo.free();
                this.fbo = null;
            }
        }
    }

    private record OpenTexture(ImBoolean open, ImBoolean visible, ImBoolean flipX, ImBoolean flipY) {
        private OpenTexture(boolean flipX, boolean flipY) {
            this(new ImBoolean(), new ImBoolean(true), new ImBoolean(flipX), new ImBoolean(flipY));
        }
    }
}

