/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.resource.editor;

import foundry.veil.Veil;
import foundry.veil.api.resource.VeilEditorEnvironment;
import foundry.veil.api.resource.VeilResource;
import foundry.veil.api.resource.VeilResourceInfo;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import org.apache.commons.io.IOUtils;

public interface ResourceFileEditor<T extends VeilResource<?>> {
    public void render();

    public void open(VeilEditorEnvironment var1, T var2);

    default public void save(byte[] data, VeilResource<?> resource) {
        VeilResourceInfo info = resource.resourceInfo();
        ((CompletableFuture)CompletableFuture.runAsync(() -> {
            try {
                if (info.isStatic()) {
                    throw new IOException("Read-only resource");
                }
                Path path = info.filePath();
                try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
                    os.write(data);
                }
                Path modPath = info.modResourcePath();
                if (modPath == null) {
                    return;
                }
                try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
                     OutputStream os = Files.newOutputStream(modPath, StandardOpenOption.TRUNCATE_EXISTING);){
                    IOUtils.copyLarge((InputStream)is, (OutputStream)os);
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Failed to write resource: {}", (Object)info.location(), (Object)e);
            }
        }, Util.m_183992_()).thenRunAsync(resource::hotReload, (Executor)Minecraft.m_91087_())).exceptionally(e -> {
            Veil.LOGGER.error("Failed to hot-swap resource: {}", (Object)info.location(), e);
            return null;
        });
    }
}

