/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.emitters.shape;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.quasar.emitters.shape.EmitterShape;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.joml.Matrix4f;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Sphere
implements EmitterShape {
    @Override
    public Vector3d getPoint(RandomSource randomSource, Vector3fc dimensions, Vector3fc rotation, Vector3dc position, boolean fromSurface) {
        double x = randomSource.m_188500_() * 2.0 - 1.0;
        double y = randomSource.m_188500_() * 2.0 - 1.0;
        double z = randomSource.m_188500_() * 2.0 - 1.0;
        Vector3d normal = new Vector3d(x, y, z).normalize();
        Vector3fc dim = dimensions;
        if (!fromSurface) {
            normal.mul(randomSource.m_188500_()).normalize();
            dim = dimensions.mul(randomSource.m_188501_(), randomSource.m_188501_(), randomSource.m_188501_(), new Vector3f());
        }
        Vector3d pos = normal.mul(dim);
        pos = pos.rotateX((double)((float)Math.toRadians(rotation.x()))).rotateY((double)((float)Math.toRadians(rotation.y()))).rotateZ((double)((float)Math.toRadians(rotation.z())));
        return pos.add(position);
    }

    @Override
    public void renderShape(PoseStack stack, VertexConsumer consumer, Vector3fc dimensions, Vector3fc rotation) {
        float radius = dimensions.x();
        Matrix4f matrix4f = stack.m_85850_().m_252922_();
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                Vector3f v1 = Sphere.parametricSphere((float)Math.toRadians((float)i * 11.25f), (float)Math.toRadians((float)j * 11.25f), radius);
                Vector3f v2 = Sphere.parametricSphere((float)Math.toRadians((float)(i + 1) * 11.25f), (float)Math.toRadians((float)j * 11.25f), radius);
                Vector3f v3 = Sphere.parametricSphere((float)Math.toRadians((float)i * 11.25f), (float)Math.toRadians((float)(j + 1) * 11.25f), radius);
                Vector3f v4 = Sphere.parametricSphere((float)Math.toRadians((float)(i + 1) * 11.25f), (float)Math.toRadians((float)(j + 1) * 11.25f), radius);
                consumer.m_252986_(matrix4f, v1.x(), v1.y(), v1.z()).m_85950_(0.15f, 0.15f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix4f, v2.x(), v2.y(), v2.z()).m_85950_(0.15f, 0.15f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix4f, v3.x(), v3.y(), v3.z()).m_85950_(0.15f, 0.15f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
                consumer.m_252986_(matrix4f, v4.x(), v4.y(), v4.z()).m_85950_(0.15f, 0.15f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            }
        }
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
    }
}

