/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.ui.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayDeque;
import java.util.Deque;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Mth;

public class ScissorStack {
    private final Deque<ScissorRegion> regions = new ArrayDeque<ScissorRegion>();

    public void push(int x, int y, int width, int height) {
        if (!this.regions.isEmpty()) {
            ScissorRegion parent = this.regions.peek();
            int x2 = x + width;
            x = Mth.m_14045_((int)x, (int)parent.x, (int)(parent.x + parent.width));
            width = Mth.m_14045_((int)x2, (int)parent.x, (int)(parent.x + parent.width)) - x;
            int y2 = y + height;
            y = Mth.m_14045_((int)y, (int)parent.y, (int)(parent.y + parent.height));
            height = Mth.m_14045_((int)y2, (int)parent.y, (int)(parent.y + parent.height)) - y;
        }
        ScissorRegion region = new ScissorRegion(x, y, width, height);
        this.regions.push(region);
        region.apply();
    }

    public void pop() {
        this.regions.pop();
        RenderSystem.disableScissor();
        if (!this.regions.isEmpty()) {
            this.regions.peek().apply();
        }
    }

    private static class ScissorRegion {
        int x;
        int y;
        int width;
        int height;

        public ScissorRegion(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }

        void apply() {
            double scale = Minecraft.m_91087_().m_91268_().m_85449_();
            int screenY = (int)((double)(Minecraft.m_91087_().m_91268_().m_85442_() - (this.y + this.height)) * scale);
            RenderSystem.enableScissor((int)((int)((double)this.x * scale)), (int)screenY, (int)((int)((double)this.width * scale)), (int)((int)((double)this.height * scale)));
        }
    }
}

