/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.render;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import foundry.veil.api.client.render.VeilRenderSystem;
import foundry.veil.api.client.render.deferred.VeilDeferredRenderer;
import foundry.veil.api.client.render.framebuffer.AdvancedFbo;
import foundry.veil.ext.GameRendererExtension;
import foundry.veil.ext.RenderTargetExtension;
import foundry.veil.impl.client.render.LevelPerspectiveCamera;
import foundry.veil.mixin.accessor.GameRendererAccessor;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3dc;
import org.joml.Vector3f;

public final class VeilLevelPerspectiveRenderer {
    private static final LevelPerspectiveCamera CAMERA = new LevelPerspectiveCamera();
    private static final Matrix4f TRANSFORM = new Matrix4f();
    private static final Matrix3f NORMAL = new Matrix3f();
    private static final Matrix4f BACKUP_PROJECTION = new Matrix4f();
    private static final Matrix3f BACKUP_INVERSE_VIEW_ROTATION = new Matrix3f();
    private static final Vector3f BACKUP_LIGHT0_POSITION = new Vector3f();
    private static final Vector3f BACKUP_LIGHT1_POSITION = new Vector3f();
    private static boolean renderingPerspective = false;

    private VeilLevelPerspectiveRenderer() {
    }

    public static void render(AdvancedFbo framebuffer, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, float partialTicks) {
        VeilLevelPerspectiveRenderer.render(framebuffer, Minecraft.m_91087_().f_91075_, modelView, projection, cameraPosition, cameraOrientation, renderDistance, partialTicks);
    }

    public static void render(AdvancedFbo framebuffer, @Nullable Entity cameraEntity, Matrix4fc modelView, Matrix4fc projection, Vector3dc cameraPosition, Quaternionfc cameraOrientation, float renderDistance, float partialTicks) {
        if (renderingPerspective) {
            return;
        }
        Minecraft minecraft = Minecraft.m_91087_();
        GameRenderer gameRenderer = minecraft.f_91063_;
        LevelRenderer levelRenderer = minecraft.f_91060_;
        Window window = minecraft.m_91268_();
        GameRendererAccessor accessor = (GameRendererAccessor)gameRenderer;
        RenderTargetExtension renderTargetExtension = (RenderTargetExtension)minecraft.m_91385_();
        long time = ((GameRendererExtension)gameRenderer).veil$getFrameStartNanos();
        CAMERA.setup(cameraPosition, cameraEntity, minecraft.f_91073_, cameraOrientation);
        PoseStack poseStack = new PoseStack();
        PoseStack.Pose pose = poseStack.m_85850_();
        poseStack.m_252931_(TRANSFORM.set(modelView));
        pose.m_252943_().mul((Matrix3fc)TRANSFORM.normal(NORMAL));
        poseStack.m_252781_(CAMERA.m_253121_());
        BACKUP_INVERSE_VIEW_ROTATION.set((Matrix3fc)RenderSystem.getInverseViewRotationMatrix());
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)NORMAL.rotate((Quaternionfc)CAMERA.m_253121_()).invert());
        float backupRenderDistance = gameRenderer.m_109152_();
        accessor.setRenderDistance(renderDistance);
        int backupWidth = window.m_85441_();
        int backupHeight = window.m_85442_();
        window.m_166450_(framebuffer.getWidth());
        window.m_166452_(framebuffer.getHeight());
        VeilDeferredRenderer deferredRenderer = VeilRenderSystem.renderer().getDeferredRenderer();
        boolean backupEnabled = deferredRenderer.isEnabled();
        if (backupEnabled) {
            deferredRenderer.disable();
        }
        BACKUP_PROJECTION.set((Matrix4fc)RenderSystem.getProjectionMatrix());
        gameRenderer.m_252879_(TRANSFORM.set(projection));
        BACKUP_LIGHT0_POSITION.set(VeilRenderSystem.getLight0Position());
        BACKUP_LIGHT1_POSITION.set(VeilRenderSystem.getLight1Position());
        HitResult backupHitResult = minecraft.f_91077_;
        Entity backupCrosshairPickEntity = minecraft.f_91076_;
        renderingPerspective = true;
        framebuffer.bindDraw(true);
        renderTargetExtension.veil$setWrapper(framebuffer);
        levelRenderer.m_253210_(poseStack, new Vec3(cameraPosition.x(), cameraPosition.y(), cameraPosition.z()), TRANSFORM);
        levelRenderer.m_109599_(poseStack, partialTicks, time, false, (Camera)CAMERA, gameRenderer, gameRenderer.m_109154_(), TRANSFORM);
        levelRenderer.m_109769_();
        renderTargetExtension.veil$setWrapper(null);
        AdvancedFbo.unbind();
        renderingPerspective = false;
        minecraft.f_91076_ = backupCrosshairPickEntity;
        minecraft.f_91077_ = backupHitResult;
        RenderSystem.setShaderLights((Vector3f)BACKUP_LIGHT0_POSITION, (Vector3f)BACKUP_LIGHT1_POSITION);
        gameRenderer.m_252879_(BACKUP_PROJECTION);
        window.m_166450_(backupWidth);
        window.m_166452_(backupHeight);
        if (backupEnabled) {
            deferredRenderer.enable();
        }
        accessor.setRenderDistance(backupRenderDistance);
        RenderSystem.setInverseViewRotationMatrix((Matrix3f)BACKUP_INVERSE_VIEW_ROTATION);
    }

    public static boolean isRenderingPerspective() {
        return renderingPerspective;
    }
}

