/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.client.graveyard.render.mesh;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.client.graveyard.render.mesh.ModelMesh;
import foundry.veil.api.client.graveyard.skeleton.InterpolatedBone;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class StaticMesh
implements ModelMesh {
    private final List<ModelMesh.Face> faces;
    final int textureWidth;
    final int textureHeight;

    public StaticMesh(int textureWidth, int textureHeight) {
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        this.faces = new ArrayList<ModelMesh.Face>();
    }

    public ModelMesh.Face[] addCube(float xSize, float ySize, float zSize, float xOffset, float yOffset, float zOffset, float xInflate, float yInflate, float zInflate, float uOffset, float vOffset) {
        return this.addCube(xSize, ySize, zSize, xOffset, yOffset, zOffset, xInflate, yInflate, zInflate, uOffset, vOffset, false);
    }

    public ModelMesh.Face[] addCube(float xSize, float ySize, float zSize, float xOffset, float yOffset, float zOffset, float xInflate, float yInflate, float zInflate, float uOffset, float vOffset, boolean mirrored) {
        float minX = xOffset;
        float minY = yOffset;
        float minZ = zOffset;
        float maxX = xOffset + xSize;
        float maxY = yOffset + ySize;
        float maxZ = zOffset + zSize;
        minX -= xInflate;
        minY -= yInflate;
        minZ -= zInflate;
        maxX += xInflate;
        maxY += yInflate;
        maxZ += zInflate;
        if (mirrored) {
            float swap = maxX;
            maxX = minX;
            minX = swap;
        }
        ModelMesh.Vertex ooo = new ModelMesh.Vertex(minX, minY, minZ);
        ModelMesh.Vertex xoo = new ModelMesh.Vertex(maxX, minY, minZ);
        ModelMesh.Vertex oyo = new ModelMesh.Vertex(minX, maxY, minZ);
        ModelMesh.Vertex ooz = new ModelMesh.Vertex(minX, minY, maxZ);
        ModelMesh.Vertex xyo = new ModelMesh.Vertex(maxX, maxY, minZ);
        ModelMesh.Vertex oyz = new ModelMesh.Vertex(minX, maxY, maxZ);
        ModelMesh.Vertex xoz = new ModelMesh.Vertex(maxX, minY, maxZ);
        ModelMesh.Vertex xyz = new ModelMesh.Vertex(maxX, maxY, maxZ);
        float u0 = uOffset;
        float u1 = uOffset + zSize;
        float u2 = uOffset + zSize + xSize;
        float u3 = uOffset + zSize + xSize + xSize;
        float u4 = uOffset + zSize + xSize + zSize;
        float u5 = uOffset + zSize + xSize + zSize + xSize;
        float v0 = vOffset;
        float v1 = vOffset + zSize;
        float v2 = vOffset + zSize + ySize;
        ModelMesh.Face[] cubeFaces = new ModelMesh.Face[]{new ModelMesh.Face(xoz, ooz, ooo, xoo, u3, v0, u2, v1, this.textureWidth, this.textureHeight, mirrored, Direction.UP), new ModelMesh.Face(xyo, oyo, oyz, xyz, u2, v1, u1, v0, this.textureWidth, this.textureHeight, mirrored, Direction.DOWN), new ModelMesh.Face(ooo, ooz, oyz, oyo, u4, v2, u2, v1, this.textureWidth, this.textureHeight, mirrored, Direction.EAST), new ModelMesh.Face(xoz, xoo, xyo, xyz, u1, v2, u0, v1, this.textureWidth, this.textureHeight, mirrored, Direction.WEST), new ModelMesh.Face(ooz, xoz, xyz, oyz, u5, v2, u4, v1, this.textureWidth, this.textureHeight, mirrored, Direction.NORTH), new ModelMesh.Face(xoo, ooo, oyo, xyo, u2, v2, u1, v1, this.textureWidth, this.textureHeight, mirrored, Direction.SOUTH)};
        Collections.addAll(this.faces, cubeFaces);
        return cubeFaces;
    }

    public ModelMesh.Face addTri(float x1, float y1, float z1, float u1, float v1, float x2, float y2, float z2, float u2, float v2, float x3, float y3, float z3, float u3, float v3, float normalX, float normalY, float normalZ) {
        ModelMesh.Face face = new ModelMesh.Face(new ModelMesh.Vertex[]{new ModelMesh.Vertex(x1, y1, z1), new ModelMesh.Vertex(x2, y2, z2), new ModelMesh.Vertex(x2, y2, z2)}, new ModelMesh.UV[]{new ModelMesh.UV(u1, v1), new ModelMesh.UV(u2, v2), new ModelMesh.UV(u3, v3)}, new Vector3f(normalX, normalY, normalZ));
        this.faces.add(face);
        return face;
    }

    public ModelMesh.Face addFace(float normalX, float normalY, float normalZ, FaceVertex ... vertices) {
        ModelMesh.Vertex[] vertArray = new ModelMesh.Vertex[vertices.length];
        ModelMesh.UV[] uvArray = new ModelMesh.UV[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            FaceVertex vertex = vertices[i];
            vertArray[i] = new ModelMesh.Vertex(vertex.x(), vertex.y(), vertex.z());
            uvArray[i] = new ModelMesh.UV(vertex.u() / (float)this.textureWidth, vertex.v() / (float)this.textureHeight);
        }
        ModelMesh.Face face = new ModelMesh.Face(vertArray, uvArray, new Vector3f(normalX, normalY, normalZ));
        this.faces.add(face);
        return face;
    }

    @Override
    public void render(InterpolatedBone part, PoseStack pPoseStack, VertexConsumer pVertexConsumer, int pPackedLight, int pPackedOverlay, float pRed, float pGreen, float pBlue, float pAlpha) {
        Matrix4f matrix4f = pPoseStack.m_85850_().m_252922_();
        Matrix3f matrix3f = pPoseStack.m_85850_().m_252943_();
        Vector3f position = new Vector3f();
        Vector3f normal = new Vector3f();
        for (ModelMesh.Face face : this.faces) {
            for (int i = 0; i < face.vertices.length; ++i) {
                ModelMesh.Vertex vertex = face.vertices[i];
                ModelMesh.UV uv = face.uvs[i];
                position.set(vertex.x(), vertex.y(), vertex.z());
                matrix4f.transformPosition(position);
                normal.set(face.normal.x(), face.normal.y(), face.normal.z());
                matrix3f.transform(normal);
                pVertexConsumer.m_5954_(position.x(), position.y(), position.z(), pRed, pGreen, pBlue, pAlpha, uv.u(), uv.v(), pPackedOverlay, pPackedLight, normal.x(), normal.y(), normal.z());
            }
        }
    }

    public record FaceVertex(float x, float y, float z, float u, float v) {
    }
}

