/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import foundry.veil.Veil;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public abstract class CodecReloadListener<T>
extends SimplePreparableReloadListener<Map<ResourceLocation, T>> {
    protected final Codec<T> codec;
    protected final FileToIdConverter converter;

    public CodecReloadListener(Codec<T> codec, FileToIdConverter converter) {
        this.codec = codec;
        this.converter = converter;
    }

    @NotNull
    protected Map<ResourceLocation, T> prepare(@NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profilerFiller) {
        HashMap data = new HashMap();
        Map resources = this.converter.m_247457_(resourceManager);
        for (Map.Entry entry : resources.entrySet()) {
            ResourceLocation location = (ResourceLocation)entry.getKey();
            ResourceLocation id = this.converter.m_245273_(location);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).m_215508_();
                try {
                    JsonElement element = JsonParser.parseReader((Reader)reader);
                    DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)element);
                    if (result.error().isPresent()) {
                        throw new JsonSyntaxException(((DataResult.PartialResult)result.error().get()).message());
                    }
                    if (data.put(id, result.result().orElseThrow()) == null) continue;
                    throw new IllegalStateException("Duplicate data file ignored with ID " + id);
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            catch (Exception e) {
                Veil.LOGGER.error("Couldn't parse data file {} from {}", new Object[]{id, location, e});
            }
        }
        return data;
    }
}

