/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.forge.mixin.resources;

import foundry.veil.Veil;
import foundry.veil.ext.PackResourcesExtension;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.IoSupplier;
import net.minecraftforge.resource.PathPackResources;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={PathPackResources.class})
public abstract class ForgePathPackResourcesMixin
implements PackResources,
PackResourcesExtension {
    @Shadow
    @Nullable
    public abstract IoSupplier<InputStream> m_8017_(String ... var1);

    @Shadow
    public abstract Path getSource();

    @Override
    public void veil$listResources(final PackResourcesExtension.PackResourceConsumer consumer) {
        String packId = this.m_5542_();
        final Path root = this.getSource();
        final String separator = root.getFileSystem().getSeparator();
        for (final PackType type : PackType.values()) {
            final Path assetPath = root.resolve(type.m_10305_());
            if (!Files.exists(assetPath, new LinkOption[0])) continue;
            try {
                Files.walkFileTree(assetPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                        String path;
                        String[] parts = assetPath.relativize(file).toString().replace(separator, "/").split("/", 2);
                        String namespace = parts.length == 1 ? "root" : parts[0];
                        ResourceLocation name = ResourceLocation.m_214293_((String)namespace, (String)(path = parts.length == 1 ? parts[0] : parts[1]));
                        if (name != null) {
                            consumer.accept(type, name, assetPath, file, PackResourcesExtension.findDevPath(root, file));
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                Veil.LOGGER.warn("Failed to list resources in {} failed!", (Object)packId, (Object)e);
            }
        }
    }

    @Override
    @Nullable
    public IoSupplier<InputStream> veil$getIcon() {
        return this.m_8017_("pack.png");
    }
}

