/*
 * Decompiled with CFR 0.152.
 */
package foundry.veil.api.quasar.emitters.shape;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import foundry.veil.api.quasar.emitters.shape.EmitterShape;
import net.minecraft.util.RandomSource;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class Torus
implements EmitterShape {
    @Override
    public Vector3d getPoint(RandomSource randomSource, Vector3fc dimensions, Vector3fc rotation, Vector3dc position, boolean fromSurface) {
        double theta = randomSource.m_188500_() * 2.0 * Math.PI;
        double phi = randomSource.m_188500_() * 2.0 * Math.PI;
        double x = Math.cos(theta) * (1.0 + 0.5 * Math.cos(phi));
        double y = Math.sin(theta) * (1.0 + 0.5 * Math.cos(phi));
        double z = (double)dimensions.z() * Math.sin(phi);
        Vector3d normal = new Vector3d(x, y, z).normalize();
        Vector3fc dim = dimensions;
        if (!fromSurface) {
            normal.mul(randomSource.m_188500_()).normalize();
            dim = dimensions.mul(randomSource.m_188501_(), randomSource.m_188501_(), randomSource.m_188501_(), new Vector3f());
        }
        Vector3d pos = normal.mul(dim);
        pos = pos.rotateX((double)((float)Math.toRadians(rotation.x()))).rotateY((double)((float)Math.toRadians(rotation.y()))).rotateZ((double)((float)Math.toRadians(rotation.z())));
        return pos.add(position);
    }

    @Override
    public void renderShape(PoseStack stack, VertexConsumer consumer, Vector3fc dimensions, Vector3fc rotation) {
        float radius = dimensions.x();
        float tubeRadius = dimensions.y();
        float angle = 0.0f;
        float angleStep = 11.25f;
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (int i = 0; i < 32; ++i) {
            float x1 = (float)((double)x + Math.cos(Math.toRadians(angle)) * (double)radius);
            float z1 = (float)((double)z + Math.sin(Math.toRadians(angle)) * (double)radius);
            float x2 = (float)((double)x + Math.cos(Math.toRadians(angle + angleStep)) * (double)radius);
            float z2 = (float)((double)z + Math.sin(Math.toRadians(angle + angleStep)) * (double)radius);
            consumer.m_252986_(stack.m_85850_().m_252922_(), x1, y, z1).m_85950_(0.15f, 0.15f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            consumer.m_252986_(stack.m_85850_().m_252922_(), x2, y, z2).m_85950_(0.15f, 0.15f, 1.0f, 1.0f).m_5601_(0.0f, 1.0f, 0.0f).m_5752_();
            angle += angleStep;
        }
    }
}

